/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.data.common;

import java.util.Objects;

public enum GemDatePattern {
    NULL("", ""),
    ISO8601Long("yyyy-MM-dd HH:mm:ss", "Y-m-d H:i:s"),
    ISO8601Short("yyyy-MM-dd", "Y-m-d"),
    ChineseDate("yyyy\u5e74MM\u6708dd\u65e5", "Y\u5e74m\u6708d\u65e5"),
    ShortDate("n/j/Y", "n/j/Y"),
    LongDate("l, F d, Y", "l, F d, Y"),
    FullDateTime("l, F d, Y g:i:s A", "l, F d, Y g:i:s A"),
    MonthDay("F d", "F d"),
    ShortTime("g:i A", "g:i A"),
    LongTime("g:i:s A", "g:i:s A"),
    SortableDateTime("Y-m-d\\TH:i:s", "Y-m-d\\TH:i:s"),
    UniversalSortableDateTime("Y-m-d H:i:sO", "Y-m-d H:i:sO"),
    YearMonth("F, Y", "F, Y");

    private String format;
    private String jsFormat;
    public final String str;

    private GemDatePattern(String format, String jsFormat) {
        this.format = format;
        this.jsFormat = jsFormat;
        this.str = format;
    }

    public String getFormat() {
        return this.format;
    }

    public String getJsFormat() {
        return this.jsFormat;
    }

    public void setJsFormat(String jsFormat) {
        this.jsFormat = jsFormat;
    }

    public static GemDatePattern getByJsFormat(String jsFormat) {
        GemDatePattern[] ts;
        for (GemDatePattern t : ts = (GemDatePattern[])GemDatePattern.class.getEnumConstants()) {
            if (!Objects.equals(t.getJsFormat(), jsFormat)) continue;
            return t;
        }
        return NULL;
    }

    public static class Constant {
        public static final String ISO8601Long = "yyyy-MM-dd HH:mm:ss";
        public static final String ISO8601Short = "yyyy-MM-dd";
        public static final String ChineseDate = "yyyy\u5e74MM\u6708dd\u65e5";
        public static final String ShortDate = "n/j/Y";
        public static final String LongDate = "l, F d, Y";
        public static final String FullDateTime = "l, F d, Y g:i:s A";
        public static final String MonthDay = "F d";
        public static final String ShortTime = "g:i A";
        public static final String LongTime = "g:i:s A";
        public static final String SortableDateTime = "Y-m-d\\TH:i:s";
        public static final String UniversalSortableDateTime = "Y-m-d H:i:sO";
        public static final String YearMonth = "F, Y";
    }
}

