/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.data.model;

import com.gw.base.data.model.annotation.GaModelField;
import com.gw.base.exception.GwException;
import com.gw.base.util.GutilReflection;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Predicate;

public interface GiModelable<ID extends Serializable>
extends Serializable {
    public static final Predicate<Field> idFieldPredicate = s -> {
        GaModelField mf = s.getDeclaredAnnotation(GaModelField.class);
        return mf != null && mf.isID();
    };

    public static <M extends GiModelable<ID>, ID extends Serializable> Class<ID> getIDClass(Class<M> cls) {
        return (Class)GiModelable.getModelGenericTypes(cls);
    }

    public static Type getModelGenericTypes(Class<?> modelClass) {
        Type[] genericInterfaces;
        for (Type type : genericInterfaces = modelClass.getGenericInterfaces()) {
            Type[] ts;
            ParameterizedType pType;
            if (type instanceof ParameterizedType && GiModelable.class.isAssignableFrom((Class)(pType = (ParameterizedType)type).getRawType()) && (ts = pType.getActualTypeArguments()).length == 1 && Serializable.class.isAssignableFrom((Class)ts[0])) {
                return ts[0];
            }
            if (!(type instanceof Class) || !GiModelable.class.isAssignableFrom((Class)type)) continue;
            return GiModelable.getModelGenericTypes((Class)type);
        }
        return null;
    }

    default public ID id() {
        Field field = GutilReflection.findField(this.getClass(), idFieldPredicate);
        if (field != null) {
            if (!this.idClass().isAssignableFrom(field.getType())) {
                throw new GwException("\u6a21\u578b\u7c7b {} idClass() {} \u7c7b\u578b\u4e0e\u6807\u8bb0@GaModelField(isID=true)\u7684\u5c5e\u6027\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u590d\u5199id()\u65b9\u6cd5\u6216\u8005idClass()\u65b9\u6cd5", new Object[]{this.getClass().getName(), this.idClass().getName()});
            }
            try {
                GutilReflection.makeAccessible((Field)field);
                return (ID)((Serializable)field.get(this));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw new GwException("\u6a21\u578b\u7c7b  {} \u6ca1\u6709\u6807\u8bb0id\u952e,\u5728id\u5c5e\u6027\u4e0a\u52a0\u6ce8\u89e3@GaModelField(isID = true)\u6216@Id \u6216 \u8986\u5199 id()\u65b9\u6cd5", new Object[]{this.getClass().getName()});
    }

    default public Class<? extends GiModelable<ID>> modelClass() {
        return this.getClass();
    }

    default public Class<ID> idClass() {
        return GiModelable.getIDClass(this.getClass());
    }
}

