/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.data.result;

import com.gw.base.data.GiValuable;
import com.gw.base.data.result.GiResultCode;
import com.gw.base.data.result.GiResultConfig;
import com.gw.base.data.result.GwEmAlertType;
import com.gw.base.sp.GwSpHelper;
import java.lang.reflect.Type;

public interface GiResult<T>
extends GiValuable<T> {
    public int code();

    public GiResult<T> andCode(int var1);

    default public GiResult<T> andCode(GiResultCode code) {
        return this.andCode((Integer)code.value());
    }

    public String alertMsg();

    public GiResult<T> andAlertMsg(String var1);

    public int alertType();

    public GiResult<T> andAlertType(int var1);

    default public GiResult<T> andAlertTypeEnum(GwEmAlertType alertTypeEnum) {
        return this.andAlertType(alertTypeEnum.value());
    }

    public GiResult<T> andValue(T var1);

    public GiResult<T> forSuccess();

    public GiResult<T> forFailure();

    public static <K> GiResult<K> successValue(K value) {
        Class<?> cls = null;
        if (value != null) {
            cls = value.getClass();
        }
        return GiResult.getResult(cls).andValue(value);
    }

    public static <K> GiResult<K> success() {
        return GiResult.successValue(null).forSuccess();
    }

    public static <K> GiResult<K> successMsg(String msg) {
        return GiResult.success().andAlertMsg(msg);
    }

    public static <K> GiResult<K> failure() {
        return GiResult.getResult(null).forFailure();
    }

    public static <K> GiResult<K> failureMsg(String msg) {
        return GiResult.failure().andAlertMsg(msg);
    }

    public static <K> GiResult<K> failureSetMsgAndType(String msg, GwEmAlertType alertType) {
        return GiResult.failureMsg(msg).andAlertTypeEnum(alertType);
    }

    public static <K> GiResult<K> failureSetCodeAndMsgAndType(int code, String msg, GwEmAlertType alertType) {
        return GiResult.failureMsg(msg).andAlertTypeEnum(alertType).andCode(code);
    }

    public static <K> GiResult<K> getResult(Class<K> resultType) {
        return ((GiResultConfig)GwSpHelper.load(GiResultConfig.class, (Type[])new Type[0])).getResult(resultType);
    }
}

