/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.data.tuples;

import com.gw.base.data.tuples.GkTuple;
import com.gw.base.data.tuples.valueintf.GkiValueKey;
import com.gw.base.data.tuples.valueintf.GkiValueValue;
import java.util.Collection;
import java.util.Iterator;

public final class GkKeyValue<A, B>
extends GkTuple
implements GkiValueKey<A>,
GkiValueValue<B> {
    private static final long serialVersionUID = 3460957157833872509L;
    private static final int SIZE = 2;
    private final A key;
    private final B value;

    public static <A, B> GkKeyValue<A, B> with(A key, B value) {
        return new GkKeyValue<A, B>(key, value);
    }

    public static <X> GkKeyValue<X, X> fromArray(X[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Array cannot be null");
        }
        if (array.length != 2) {
            throw new IllegalArgumentException("Array must have exactly 2 elements in order to create a KeyValue. Size is " + array.length);
        }
        return new GkKeyValue<X, X>(array[0], array[1]);
    }

    public static <X> GkKeyValue<X, X> fromCollection(Collection<X> collection) {
        return GkKeyValue.fromIterable(collection);
    }

    public static <X> GkKeyValue<X, X> fromIterable(Iterable<X> iterable) {
        return GkKeyValue.fromIterable(iterable, 0, true);
    }

    public static <X> GkKeyValue<X, X> fromIterable(Iterable<X> iterable, int index) {
        return GkKeyValue.fromIterable(iterable, index, false);
    }

    private static <X> GkKeyValue<X, X> fromIterable(Iterable<X> iterable, int index, boolean exactSize) {
        if (iterable == null) {
            throw new IllegalArgumentException("Iterable cannot be null");
        }
        boolean tooFewElements = false;
        Object element0 = null;
        Object element1 = null;
        Iterator<X> iter = iterable.iterator();
        for (int i = 0; i < index; ++i) {
            if (iter.hasNext()) {
                iter.next();
                continue;
            }
            tooFewElements = true;
        }
        if (iter.hasNext()) {
            element0 = iter.next();
        } else {
            tooFewElements = true;
        }
        if (iter.hasNext()) {
            element1 = iter.next();
        } else {
            tooFewElements = true;
        }
        if (tooFewElements && exactSize) {
            throw new IllegalArgumentException("Not enough elements for creating a KeyValue (2 needed)");
        }
        if (iter.hasNext() && exactSize) {
            throw new IllegalArgumentException("Iterable must have exactly 2 available elements in order to create a KeyValue.");
        }
        return new GkKeyValue<Object, Object>(element0, element1);
    }

    public GkKeyValue(A key, B value) {
        super(key, value);
        this.key = key;
        this.value = value;
    }

    @Override
    public A getKey() {
        return this.key;
    }

    @Override
    public B getValue() {
        return this.value;
    }

    @Override
    public int getSize() {
        return 2;
    }

    public <X> GkKeyValue<X, B> setKey(X key) {
        return new GkKeyValue<X, B>(key, this.value);
    }

    public <Y> GkKeyValue<A, Y> setValue(Y value) {
        return new GkKeyValue<A, Y>(this.key, value);
    }
}

