/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.data.tuples;

import com.gw.base.data.tuples.GkTuple;
import com.gw.base.data.tuples.valueintf.GkiValueLabel;
import com.gw.base.data.tuples.valueintf.GkiValueValue;
import java.util.Collection;
import java.util.Iterator;

public final class GkLabelValue<A, B>
extends GkTuple
implements GkiValueLabel<A>,
GkiValueValue<B> {
    private static final long serialVersionUID = 5055574980300695706L;
    private static final int SIZE = 2;
    private final A label;
    private final B value;

    public static <A, B> GkLabelValue<A, B> with(A label, B value) {
        return new GkLabelValue<A, B>(label, value);
    }

    public static <X> GkLabelValue<X, X> fromArray(X[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Array cannot be null");
        }
        if (array.length != 2) {
            throw new IllegalArgumentException("Array must have exactly 2 elements in order to create a LabelValue. Size is " + array.length);
        }
        return new GkLabelValue<X, X>(array[0], array[1]);
    }

    public static <X> GkLabelValue<X, X> fromCollection(Collection<X> collection) {
        return GkLabelValue.fromIterable(collection);
    }

    public static <X> GkLabelValue<X, X> fromIterable(Iterable<X> iterable) {
        return GkLabelValue.fromIterable(iterable, 0, true);
    }

    public static <X> GkLabelValue<X, X> fromIterable(Iterable<X> iterable, int index) {
        return GkLabelValue.fromIterable(iterable, index, false);
    }

    private static <X> GkLabelValue<X, X> fromIterable(Iterable<X> iterable, int index, boolean exactSize) {
        if (iterable == null) {
            throw new IllegalArgumentException("Iterable cannot be null");
        }
        boolean tooFewElements = false;
        Object element0 = null;
        Object element1 = null;
        Iterator<X> iter = iterable.iterator();
        for (int i = 0; i < index; ++i) {
            if (iter.hasNext()) {
                iter.next();
                continue;
            }
            tooFewElements = true;
        }
        if (iter.hasNext()) {
            element0 = iter.next();
        } else {
            tooFewElements = true;
        }
        if (iter.hasNext()) {
            element1 = iter.next();
        } else {
            tooFewElements = true;
        }
        if (tooFewElements && exactSize) {
            throw new IllegalArgumentException("Not enough elements for creating a LabelValue (2 needed)");
        }
        if (iter.hasNext() && exactSize) {
            throw new IllegalArgumentException("Iterable must have exactly 2 available elements in order to create a LabelValue.");
        }
        return new GkLabelValue<Object, Object>(element0, element1);
    }

    public GkLabelValue(A label, B value) {
        super(label, value);
        this.label = label;
        this.value = value;
    }

    @Override
    public A getLabel() {
        return this.label;
    }

    @Override
    public B getValue() {
        return this.value;
    }

    @Override
    public int getSize() {
        return 2;
    }

    public <X> GkLabelValue<X, B> setLabel(X label) {
        return new GkLabelValue<X, B>(label, this.value);
    }

    public <Y> GkLabelValue<A, Y> setValue(Y value) {
        return new GkLabelValue<A, Y>(this.label, value);
    }
}

