/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.exception;

import com.gw.base.data.GwValidateException;
import com.gw.base.data.result.GiResult;
import com.gw.base.data.result.GwEmAlertType;
import com.gw.base.exception.GwException;
import com.gw.base.permission.GwPermissionException;
import com.gw.base.user.GwNoLoginException;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class GwExceptionResultConverter {
    private static final Map<Class<? extends Exception>, Integer> primitiveExceptionCodeMap = new IdentityHashMap<Class<? extends Exception>, Integer>(8);
    private static final Map<Class<? extends Exception>, Integer> primitiveExceptionAlertTypeMap;

    public static void regExceptionCode(Class<? extends Exception> exCls, Integer code) {
        primitiveExceptionCodeMap.put(exCls, code);
    }

    public static Integer getExceptionCode(Class<? extends Exception> exCls) {
        if (primitiveExceptionCodeMap.containsKey(exCls)) {
            return primitiveExceptionCodeMap.get(exCls);
        }
        return GwExceptionResultConverter.getExceptionCode(exCls.getSuperclass());
    }

    public static void regExceptionAlertType(Class<? extends Exception> exCls, GwEmAlertType alertType) {
        primitiveExceptionAlertTypeMap.put(exCls, alertType.value());
    }

    public static void regExceptionAlertType(Class<? extends Exception> exCls, Integer alertType) {
        primitiveExceptionAlertTypeMap.put(exCls, alertType);
    }

    public static Integer getExceptionAlertType(Class<? extends Exception> exCls) {
        if (primitiveExceptionAlertTypeMap.containsKey(exCls)) {
            return primitiveExceptionAlertTypeMap.get(exCls);
        }
        return GwExceptionResultConverter.getExceptionAlertType(exCls.getSuperclass());
    }

    public static GiResult<Exception> convert(Exception ex) {
        GiResult<Exception> res = GiResult.getResult(Exception.class);
        res.andAlertMsg(ex.getMessage());
        res.andValue(ex);
        res.andCode(GwExceptionResultConverter.getExceptionCode(ex.getClass()));
        res.andAlertType(GwExceptionResultConverter.getExceptionAlertType(ex.getClass()));
        return res;
    }

    static {
        primitiveExceptionCodeMap.put(Exception.class, 999);
        primitiveExceptionCodeMap.put(GwException.class, 998);
        primitiveExceptionCodeMap.put(GwNoLoginException.class, 399);
        primitiveExceptionCodeMap.put(GwPermissionException.class, 799);
        primitiveExceptionCodeMap.put(GwValidateException.class, 499);
        primitiveExceptionAlertTypeMap = new IdentityHashMap<Class<? extends Exception>, Integer>(8);
        primitiveExceptionAlertTypeMap.put(Exception.class, GwEmAlertType.\u4e0d\u5f39\u68460.value());
        primitiveExceptionAlertTypeMap.put(GwException.class, GwEmAlertType.\u65e0\u9700\u5173\u95ed\u7684\u9519\u8bef3.value());
        primitiveExceptionAlertTypeMap.put(GwNoLoginException.class, GwEmAlertType.\u65e0\u9700\u5173\u95ed\u7684\u9519\u8bef3.value());
        primitiveExceptionAlertTypeMap.put(GwPermissionException.class, GwEmAlertType.\u65e0\u9700\u5173\u95ed\u7684\u63d0\u793a1.value());
        primitiveExceptionAlertTypeMap.put(GwValidateException.class, GwEmAlertType.\u65e0\u9700\u5173\u95ed\u7684\u63d0\u793a1.value());
    }
}

