/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.gpa.entity;

import com.gw.base.data.model.GiModelable;
import com.gw.base.exception.GwException;
import com.gw.base.util.GutilReflection;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.function.Predicate;

public interface GiEntityable<PK extends Serializable>
extends GiModelable<PK> {
    public static final Predicate<Field> pkFieldPredicate = s -> {
        Annotation[] ans;
        for (Annotation an : ans = s.getAnnotations()) {
            if (!"javax.persistence.EmbeddedId".equals(an.annotationType().getName()) && !"javax.persistence.Id".equals(an.annotationType().getName())) continue;
            return true;
        }
        return false;
    };

    @Override
    default public PK id() {
        Field field = GutilReflection.findField(this.getClass(), pkFieldPredicate);
        if (field != null) {
            if (!this.idClass().isAssignableFrom(field.getType())) {
                throw new GwException("\u5b9e\u4f53\u7c7b {} idClass() {} \u7c7b\u578b\u4e0e\u6807\u8bb0@Id\u7684\u5c5e\u6027\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u590d\u5199id()\u65b9\u6cd5\u6216\u8005idClass()\u65b9\u6cd5", new Object[]{this.getClass().getName(), this.idClass().getName()});
            }
            try {
                GutilReflection.makeAccessible((Field)field);
                return (PK)((Serializable)field.get(this));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (PK)GiModelable.super.id();
    }

    @Override
    default public Class<? extends GiEntityable<PK>> modelClass() {
        return this.getClass();
    }
}

