/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.gpa.section;

import com.gw.base.gpa.section.DateSectionModel;
import com.gw.base.gpa.section.SectionDao;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DateSectionDao<M extends DateSectionModel<PK>, PK extends Serializable>
extends SectionDao<M, PK, Date> {
    private final ThreadLocal<DateFormat> dateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return DateSectionDao.this.getDateFormatBySectionType(DateSectionDao.this.getDateSectionType());
        }
    };

    protected abstract String getColumnDate();

    protected abstract DateSectionType getDateSectionType();

    public Set<String> getVisibleTableNamesByDate(Date bDate, Date eDate) {
        String tName;
        HashSet<String> set = new HashSet<String>();
        if (bDate.after(eDate)) {
            return set;
        }
        Date beginDate = bDate;
        Calendar c = Calendar.getInstance();
        DateSectionType dst = this.getDateSectionType();
        while (beginDate.before(eDate)) {
            tName = this.getTableNamePrefix() + this.getTableNameSuffix(beginDate);
            if (this.hasCacheTableName(tName)) {
                set.add(tName);
            }
            c.setTime(beginDate);
            if (dst == DateSectionType.\u5e74) {
                c.add(1, 1);
            } else if (dst == DateSectionType.\u6708) {
                c.add(2, 1);
            } else if (dst == DateSectionType.\u5468) {
                c.add(3, 1);
            } else if (dst == DateSectionType.\u65e5) {
                c.add(5, 1);
            } else if (dst == DateSectionType.\u65f6) {
                c.add(10, 1);
            } else if (dst == DateSectionType.\u5206) {
                c.add(12, 1);
            }
            beginDate = c.getTime();
        }
        tName = this.getTableNamePrefix() + this.getTableNameSuffix(eDate);
        if (this.hasCacheTableName(tName)) {
            set.add(tName);
        }
        return set;
    }

    @Override
    public String getTableNameSuffix(Date factor) {
        return this.dateFormat.get().format(factor);
    }

    protected DateFormat getDateFormatBySectionType(DateSectionType dst) {
        if (dst == DateSectionType.\u5e74) {
            return new SimpleDateFormat("yyyy");
        }
        if (dst == DateSectionType.\u6708) {
            return new SimpleDateFormat("yyyy_MM");
        }
        if (dst == DateSectionType.\u5468) {
            return new SimpleDateFormat("YYYY_ww");
        }
        if (dst == DateSectionType.\u65e5) {
            return new SimpleDateFormat("yyyy_MM_dd");
        }
        if (dst == DateSectionType.\u65f6) {
            return new SimpleDateFormat("yyyy_MM_dd_HH");
        }
        if (dst == DateSectionType.\u5206) {
            return new SimpleDateFormat("yyyy_MM_dd_HH_mm");
        }
        return new SimpleDateFormat("yyyy");
    }

    public int saveSection(List<M> list) {
        if (list == null || list.isEmpty()) {
            return 0;
        }
        HashMap section = new HashMap();
        List<DateSectionModel> item = null;
        for (DateSectionModel dateSectionModel : list) {
            String tn = this.getTableNameByFactor(dateSectionModel.factor() != null ? dateSectionModel.factor() : new Date(), false);
            if (section.containsKey(tn)) {
                item = (List)section.get(tn);
            } else {
                item = new ArrayList();
                section.put(tn, item);
            }
            item.add(dateSectionModel);
        }
        for (Map.Entry entry : section.entrySet()) {
            this.saveBatch((List)entry.getValue(), this.getExistTableName((String)entry.getKey()));
        }
        return list.size();
    }

    public int saveSectionOneByOne(List<M> list) {
        if (list == null || list.isEmpty()) {
            return 0;
        }
        HashMap section = new HashMap();
        List<DateSectionModel> item = null;
        for (DateSectionModel dateSectionModel : list) {
            String tn = this.getTableNameByFactor(dateSectionModel.factor() != null ? dateSectionModel.factor() : new Date(), false);
            if (section.containsKey(tn)) {
                item = (List)section.get(tn);
            } else {
                item = new ArrayList();
                section.put(tn, item);
            }
            item.add(dateSectionModel);
        }
        for (Map.Entry entry : section.entrySet()) {
            this.saveBatch((List)entry.getValue(), this.getExistTableName((String)entry.getKey()));
        }
        return list.size();
    }

    public int saveOrUpdateSection(List<M> list) {
        if (list == null || list.isEmpty()) {
            return 0;
        }
        HashMap section = new HashMap();
        List<DateSectionModel> item = null;
        for (DateSectionModel m : list) {
            String tn = this.getTableNameByFactor(m.factor() != null ? m.factor() : new Date(), false);
            if (section.containsKey(tn)) {
                item = (List)section.get(tn);
            } else {
                item = new ArrayList();
                section.put(tn, item);
            }
            item.add(m);
        }
        int len = 0;
        for (Map.Entry enty : section.entrySet()) {
            len = this.saveOrUpdateBatch((List)enty.getValue(), (String)enty.getKey()) + len;
        }
        return len;
    }

    public static enum DateSectionType {
        \u5e74,
        \u6708,
        \u5468,
        \u65e5,
        \u65f6,
        \u5206;

    }
}

