/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.gpa.section;

import com.gw.base.gpa.dao.GiDao;
import com.gw.base.gpa.section.SectionModel;
import com.gw.base.util.GutilClass;
import com.gw.base.util.GutilGenericType;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public abstract class SectionDao<M extends SectionModel<PK, F>, PK extends Serializable, F>
implements GiDao<M, PK> {
    protected Set<String> tableNames = new HashSet<String>();
    private Object lock = new Object();
    private String driverName = null;

    public abstract <T> List<T> queryForList(String var1, Class<T> var2);

    public abstract List<Map<String, Object>> queryForList(String var1);

    public abstract void excuteSql(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freshTables() {
        Object object = this.lock;
        synchronized (object) {
            this.tableNames.clear();
            List<String> tbs = this.getExistTableNames();
            if (tbs != null) {
                this.tableNames.addAll(tbs);
            }
        }
    }

    public Class<F> getFactorClass() {
        return (Class)GutilGenericType.resolveTypeArguments((Class)GutilClass.getUserClass((Object)this), SectionDao.class)[2];
    }

    protected List<String> getExistTableNames() {
        if (this.isPostgresql()) {
            return this.queryForList("SELECT tablename FROM pg_tables WHERE tablename NOT LIKE 'pg%' AND tablename NOT LIKE 'sql_%' AND tablename LIKE '" + this.getTableNamePrefix() + "%'  ORDER  BY  tablename;", String.class);
        }
        if (this.isMysql()) {
            return this.queryForList("select table_name from information_schema.tables where table_name like '" + this.getTableNamePrefix() + "%' and table_type='base table'  ORDER BY table_name DESC ", String.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCacheTableName(String tableName) {
        Object object = this.lock;
        synchronized (object) {
            return this.tableNames.contains(tableName);
        }
    }

    public String getExistTableName(String tableName) {
        if (!this.hasCacheTableName(tableName)) {
            String sql = this.getCreateTableSql(tableName);
            try {
                this.excuteSql(sql);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.freshTables();
        }
        return tableName;
    }

    public String getTableNameByFactor(F factor, boolean autoCreate) {
        String tableName = this.getTableNamePrefix() + this.getTableNameSuffix(factor);
        return autoCreate ? this.getExistTableName(tableName) : tableName;
    }

    protected abstract String getTableNameSuffix(F var1);

    protected abstract String getTableNamePrefix();

    protected abstract String getCreateTableSql(String var1);

    protected abstract DataSource getDataSource();

    public boolean isMysql() {
        return this.getDriverNameUpperCase().indexOf("MYSQL") != -1;
    }

    public boolean isPostgresql() {
        return this.getDriverNameUpperCase().indexOf("POSTGRESQL") != -1;
    }

    protected String getDriverNameUpperCase() {
        if (this.driverName == null) {
            try {
                this.driverName = this.getDataSource().getConnection().getMetaData().getDriverName().toUpperCase();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return this.driverName;
    }

    public abstract String getColumnId();

    public List<String> getExistingIds(Set<PK> ids, String tableName) {
        String columnId = this.getColumnId();
        StringBuffer sql = new StringBuffer("SELECT ").append(columnId).append(" FROM ").append(tableName).append(" WHERE ").append(columnId).append(" in (");
        Class pkCls = this.getPKClass();
        boolean isNumber = Number.class.isAssignableFrom(pkCls);
        for (Serializable id : ids) {
            if (isNumber) {
                sql.append(id).append(",");
                continue;
            }
            sql.append("'").append(id).append("',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        return this.queryForList(sql.toString(), String.class);
    }

    public int saveOrUpdateBatch(List<M> list, String tableName) {
        int addSize;
        String tn = this.getExistTableName(tableName);
        HashSet ids = new HashSet();
        for (SectionModel m : list) {
            ids.add(m.id());
        }
        List<String> existingIds = this.getExistingIds(ids, tn);
        ArrayList<SectionModel> sectionUpdate = new ArrayList<SectionModel>();
        ArrayList<SectionModel> sectionAdd = new ArrayList<SectionModel>();
        for (SectionModel it : list) {
            if (existingIds.contains(it.id())) {
                sectionUpdate.add(it);
                continue;
            }
            sectionAdd.add(it);
        }
        if (sectionUpdate.size() > 0) {
            this.updateBatch(sectionUpdate, tableName);
        }
        if ((addSize = sectionAdd.size()) > 0) {
            this.saveBatch(sectionAdd, tableName);
        }
        return addSize;
    }

    public void updateBatch(List<M> list, String tableName) {
        this.deleteBatch(list, tableName);
        this.saveBatch(list, tableName);
    }

    public void deleteBatch(List<M> list, String tableName) {
        if (list == null || list.size() == 0) {
            return;
        }
        String columnId = this.getColumnId();
        StringBuffer sql = new StringBuffer("DELETE FROM ").append(tableName).append(" WHERE ").append(columnId).append(" in (");
        for (SectionModel item : list) {
            sql.append("'").append(item.id()).append("',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        this.excuteSql(sql.toString());
    }

    protected abstract void saveBatch(List<M> var1, String var2);

    protected abstract void saveBatchOneByOne(List<M> var1, String var2);
}

