/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.gpa.support;

import com.gw.base.lang.lambda.GkSerializableFunction;
import com.gw.base.lang.lambda.GkfLambdaMeta;
import com.gw.base.util.GutilLambda;
import java.io.Serializable;
import java.util.Locale;
import java.util.Optional;

public class GwOrder<T>
implements Serializable {
    private static final long serialVersionUID = 1522511010900108987L;
    private static final boolean DEFAULT_IGNORE_CASE = false;
    private static final NullHandling DEFAULT_NULL_HANDLING = NullHandling.NATIVE;
    public static final Direction DEFAULT_DIRECTION = Direction.ASC;
    private Direction direction = DEFAULT_DIRECTION;
    private boolean ignoreCase = false;
    private NullHandling nullHandling = DEFAULT_NULL_HANDLING;
    private Class<T> entityClass;
    private String property;
    private GkSerializableFunction<T, ?> propertyFun;

    public GwOrder(Class<T> typeClass) {
        this.entityClass = typeClass;
    }

    public static <T> GwOrder<T> asc(String property, Class<T> typeClass) {
        GwOrder<T> order = new GwOrder<T>(typeClass);
        order.property = property;
        return order.with(Direction.ASC);
    }

    public static <T> GwOrder<T> desc(String property, Class<T> typeClass) {
        GwOrder<T> order = new GwOrder<T>(typeClass);
        order.property = property;
        return order.with(Direction.DESC);
    }

    public static <T> GwOrder<T> asc(GkSerializableFunction<T, ?> propertyFunction) {
        GwOrder<T> order = new GwOrder<T>(null).with(Direction.ASC);
        order.propertyFun = propertyFunction;
        return order;
    }

    public static <T> GwOrder<T> desc(GkSerializableFunction<T, ?> propertyFunction) {
        GwOrder<T> order = new GwOrder<T>(null).with(Direction.DESC);
        order.propertyFun = propertyFunction;
        return order;
    }

    public Class<T> getEntityClass() {
        if (this.entityClass == null) {
            GkfLambdaMeta lm = GutilLambda.extract(this.propertyFun);
            this.entityClass = lm.getInstantiatedClass();
        }
        return this.entityClass;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public String getProperty() {
        return this.property;
    }

    public GkSerializableFunction<T, ?> getPropertyFun() {
        return this.propertyFun;
    }

    public boolean isAscending() {
        return this.direction.isAscending();
    }

    public boolean isDescending() {
        return this.direction.isDescending();
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public NullHandling getNullHandling() {
        return this.nullHandling;
    }

    public GwOrder<T> with(Direction direction) {
        this.direction = direction;
        return this;
    }

    public GwOrder<T> ignoreCase() {
        this.ignoreCase = true;
        return this;
    }

    public GwOrder<T> with(NullHandling nullHandling) {
        this.nullHandling = nullHandling;
        return this;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.direction.hashCode();
        result = 31 * result + this.property.hashCode();
        result = 31 * result + (this.ignoreCase ? 1 : 0);
        result = 31 * result + this.nullHandling.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GwOrder)) {
            return false;
        }
        GwOrder that = (GwOrder)obj;
        return this.entityClass.equals(that.entityClass) && this.direction.equals((Object)that.direction) && this.property.equals(that.property) && this.ignoreCase == that.ignoreCase && this.nullHandling.equals((Object)that.nullHandling);
    }

    public String toString() {
        String result = String.format("%s: %s", new Object[]{this.property, this.direction});
        if (!NullHandling.NATIVE.equals((Object)this.nullHandling)) {
            result = result + ", " + (Object)((Object)this.nullHandling);
        }
        if (this.ignoreCase) {
            result = result + ", ignoring case";
        }
        return result;
    }

    public static enum NullHandling {
        NATIVE,
        NULLS_FIRST,
        NULLS_LAST;

    }

    public static enum Direction {
        ASC,
        DESC;


        public boolean isAscending() {
            return this.equals((Object)ASC);
        }

        public boolean isDescending() {
            return this.equals((Object)DESC);
        }

        public String value() {
            return this.name();
        }

        public static Direction fromString(String value) {
            try {
                return Direction.valueOf(value.toUpperCase(Locale.US));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid value '%s' for orders given! Has to be either 'desc' or 'asc' (case insensitive).", value), e);
            }
        }

        public static Optional<Direction> fromOptionalString(String value) {
            try {
                return Optional.of(Direction.fromString(value));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        }
    }
}

