/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.gpa.support;

import com.gw.base.gpa.support.GwOrder;
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilStr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class GwSort
implements Serializable {
    private static final long serialVersionUID = -1586646056446727841L;
    private static final GwSort UNSORTED = GwSort.by(new GwOrder[0]);
    public static final GwOrder.Direction DEFAULT_DIRECTION = GwOrder.Direction.ASC;
    private final List<GwOrder<?>> orders;

    public GwSort(List<GwOrder<?>> orders) {
        this.orders = orders;
    }

    public static GwSort by(List<GwOrder<?>> orders) {
        GutilAssert.notNull(orders, (String)"GwOrders must not be null!");
        return orders.isEmpty() ? GwSort.unsorted() : new GwSort(orders);
    }

    public static GwSort by(GwOrder ... orders) {
        GutilAssert.notNull((Object)orders, (String)"GwOrders must not be null!");
        return new GwSort(Arrays.asList(orders));
    }

    public static GwSort unsorted() {
        return UNSORTED;
    }

    public boolean isEmpty() {
        return this.orders.isEmpty();
    }

    public void clear() {
        this.orders.clear();
    }

    public GwSort and(GwSort sort) {
        GutilAssert.notNull((Object)sort, (String)"Sort must not be null!");
        ArrayList these = new ArrayList();
        for (GwOrder<?> order : this.orders) {
            these.add(order);
        }
        return GwSort.by(these);
    }

    public GwOrder<?> getOrderFor(String property) {
        for (GwOrder<?> order : this.orders) {
            if (!order.getProperty().equals(property)) continue;
            return order;
        }
        return null;
    }

    public Iterator<GwOrder<?>> iterator() {
        return this.orders.iterator();
    }

    public void forEach(Consumer<? super GwOrder> action) {
        this.orders.forEach(action);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GwSort)) {
            return false;
        }
        GwSort that = (GwSort)obj;
        return this.orders.equals(that.orders);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.orders.hashCode();
        return result;
    }

    public String toString() {
        return this.isEmpty() ? "UNSORTED" : GutilStr.collectionToCommaDelimitedString(this.orders);
    }
}

