/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.user;

import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.permission.GiPermission;
import com.gw.base.session.GiSession;
import com.gw.base.user.permission.GiPermissionUser;
import com.gw.base.user.session.GiSessionUser;
import java.io.Serializable;
import java.util.Collection;

public interface GiPermissionSessionUser<ID extends Serializable>
extends GiSessionUser<ID>,
GiPermissionUser<ID> {
    public static final GiLoger logger = GwLoger.getLoger(GiPermissionSessionUser.class);

    public static <T extends GiSessionUser<?>> String getPermissionKeyInSession(Class<T> userClass) {
        return "gw-session-permission-" + userClass.getName();
    }

    @Override
    default public void sessionLogin() {
        GiSessionUser.super.sessionLogin();
        this.permissions();
    }

    @Override
    default public void sessionLogout() {
        GiSession session = this.userSession(false);
        if (session != null) {
            session.removeAttribute(GiPermissionSessionUser.getPermissionKeyInSession(this.sessionUserType()));
        }
        GiSessionUser.super.sessionLogout();
    }

    @Override
    default public Collection<? extends GiPermission> permissions() {
        GiSession session = this.userSession(true);
        Object obj = session.getAttribute(GiPermissionSessionUser.getPermissionKeyInSession(this.sessionUserType()));
        if (obj == null) {
            Collection<GiPermission> res = GiPermissionUser.super.permissions();
            session.setAttribute(GiPermissionSessionUser.getPermissionKeyInSession(this.sessionUserType()), res);
            return res;
        }
        return (Collection)obj;
    }
}

