/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.user.session;

import com.gw.base.active.GiActivable;
import com.gw.base.session.GiSession;
import com.gw.base.user.GiUser;
import com.gw.base.user.session.GiUserSessionProvider;
import java.io.Serializable;

public interface GiSessionUser<ID extends Serializable>
extends GiUser<ID> {
    public static <T extends GiSessionUser<?>> String getUserKeyInSession(Class<T> userClass) {
        return "gw-session-user-" + userClass.getName();
    }

    public static <T extends GiSessionUser<?>> T getUser(Class<T> userClass) {
        Object obj;
        GiUserSessionProvider<T> provider = GiUserSessionProvider.getProvider(userClass);
        GiSession session = provider.userSession(false);
        if (session != null && (obj = session.getAttribute(GiSessionUser.getUserKeyInSession(userClass))) != null) {
            return (T)((GiSessionUser)obj);
        }
        return null;
    }

    default public <T extends GiSessionUser<?>> Class<T> sessionUserType() {
        return this.getClass();
    }

    default public GiSession userSession(boolean autoCreate) {
        return GiUserSessionProvider.getProvider(this.sessionUserType()).userSession(autoCreate);
    }

    default public void sessionLogin() {
        this.userSession(true).setAttribute(GiSessionUser.getUserKeyInSession(this.sessionUserType()), this);
        if (this instanceof GiActivable) {
            ((GiActivable)((Object)this)).active();
        }
    }

    default public void sessionLogout() {
        GiSession session;
        if (this instanceof GiActivable) {
            ((GiActivable)((Object)this)).deactive();
        }
        if ((session = this.userSession(false)) != null) {
            session.removeAttribute(GiSessionUser.getUserKeyInSession(this.sessionUserType()));
        }
    }
}

