package com.gw.base.concurrent;


public class InterruptUtil {

    final boolean previouslyInterrupted;

    public InterruptUtil() {
        super();
        previouslyInterrupted = Thread.currentThread().isInterrupted();
    }

    public void maskInterruptFlag() {
        if (previouslyInterrupted) {
            Thread.interrupted();
        }
    }

    public void unmaskInterruptFlag() {
        if (previouslyInterrupted) {
            try {
                Thread.currentThread().interrupt();
            } catch (SecurityException se) {
                //addError("Failed to intrreupt current thread", se);
            }
        }
    }

}