package com.gw.base.log;


import com.gw.base.lang.caller.GkCallerUtil;
import com.gw.base.lang.invoke.GkMethodHand;
import com.gw.base.lang.invoke.GaMethodHandDefine;
import com.gw.base.lang.invoke.GaMethodHandImpl;
import com.gw.base.lang.invoke.GaMethodHandImpl.ImplType;

public class GwLoger{
	
	private GwLoger() {}
	
	static {
		GkMethodHand.implFromClass(GwLoger.class);
	}
	
	public static GiLoger getLoger(Class<?> clazz) {
		return getLoger(clazz.getName());
	}

	@GaMethodHandDefine(expectClassName = "com.gw.spi.log.Log4Gw")
	public static GiLoger getLoger(String name) {
		return (GiLoger)GkMethodHand.invokeSelf(name);
	}
	
	
	public static GiLoger getLoger() {
		return getLoger(GkCallerUtil.getCallerName());
	}
    

	@GaMethodHandImpl(implClass = GwLoger.class, implMethod = "getLoger", type = ImplType.comity)
	private static GiLoger _getLoger(String name) {
		return GwConsoleLog.forName(name);
	}

}
