package com.gw.base.sp;

import com.gw.base.tool.GkConcurrentReferenceHashMap;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

/**
 * 带缓存的SpLoader父类
 * @author Ray
 *
 */
public abstract class GwCacheSpLoader implements GkSpLoader{
	
	/**
	 * 默认的缓存key方式
	 * @param cls
	 * @param types
	 * @return
	 */
	public static String strKeyForClassAndTypes(Class<?> cls,Type[] types) {
		String key = cls.getName();
		if(types != null && types.length > 0) {
			for(Type type:types) {
				key = key +"-"+ type.getTypeName();
			}
		}
		return key;
	}
	
	private final Map<String, Object> entityCacheMap = new GkConcurrentReferenceHashMap<String, Object>();

	private final ReentrantLock LOCK = new ReentrantLock();
	/**
	 * 获取缓存
	 * @param <T>
	 * @param cls
	 * @param types
	 * @return
	 */
	@Override
	public <T> T load(Class<T> cls,Type[] types) {
		String key = cacheKey(cls,types);
		Object obj = entityCacheMap.get(key);
		if(obj != null) {
			return (T)obj;
		}
		return null;
	}
	
	/**
	 * 设置缓存
	 * @param <T>
	 * @param cls
	 * @param types
	 * @param t
	 */
	public <T> void setCache(Class<T> cls,Type[] types,T t) {
		String key = cacheKey(cls,types);
		entityCacheMap.put(key, t);
	}
	
	/**
	 * 缓存Key
	 * @param cls
	 * @param types
	 * @return
	 */
	public String cacheKey(Class<?> cls,Type[] types) {
		
		return strKeyForClassAndTypes(cls,types);
		
	}
	

}
