package com.gw.base.sp;

import com.gw.base.exception.GwException;
import com.gw.base.tool.GkConcurrentReferenceHashMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


/**
 * 
 * Service Provider 工具
 * 
 * @author Ray
 *
 */
public class GwSpHelper {
	
	
	private GwSpHelper() {
		
	}
	
	/**
	 * sploader 缓存
	 */
	private static final Map<Class<? extends GkSpLoader>, GkSpLoader> LOADER_CACHE = new ConcurrentHashMap<Class<? extends GkSpLoader>, GkSpLoader>();

    private static GkSpLoader getGkSpiLoader(Class<? extends GkSpLoader> loaderClass) {

		return LOADER_CACHE.computeIfAbsent(loaderClass,c -> {
			try {
				return c.newInstance();
			} catch (Exception e) {
				throw new GwException(e,"创建GkSpLoader发生错误：{} ",loaderClass.getName());
			}
		});
    }
    
    
    /**
     * 接口实现对象的缓存，采用弱引用方式，singleTon = false 的情况下不缓存
     */
    private static final Map<Class<?>, Object> entityTableMap = new GkConcurrentReferenceHashMap<Class<?>, Object>();
	
    /**
     * 获取一个接口的实现
     * @param <T>
     * @param requiredType 接口类型
     * @param types 泛型
     * @return
     */
    @SuppressWarnings("unchecked")
    public static <T> T load(Class<T> requiredType,Type... types) {
    	
    	GkSP spiAn = requiredType.getAnnotation(GkSP.class);
    	if(spiAn == null) {
    		throw new GwException("获取sp实现的接口必须包含GkSP注解：{} ",requiredType.getName());
    	}
    	
    	T res = null;
    	
    	if(spiAn.singleton()) {
    		res = (T)entityTableMap.get(requiredType);
    	}
    	
    	if(res == null) {
	    	Class<? extends GkSpLoader>[] loaders = spiAn.loader();
	    	for(Class<? extends GkSpLoader> loader : loaders) {
	    		res = getGkSpiLoader(loader).load(requiredType,types);
	    		if(res != null) {
	    			break;
	    		}
	    	}
	    	if(res == null) {
	    		res = getGkSpiLoader(GwPlaceHolderSpLoader.class).load(requiredType,types);
	    	}
	    		
    	}
    	return res;
	}
    
    
    
    
    //这个先放一放，好像没有应用场景
    public static <T> T load(String name, Class<T> requiredType){
    	return null;
	}

}
