/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.bean;

import com.gw.base.util.GutilArray;
import com.gw.base.util.GutilClass;
import com.gw.base.util.GutilReflection;
import com.gw.base.util.GutilStr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GkBeanPath
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final char[] EXP_CHARS = new char[]{'.', '[', ']'};
    private boolean isStartWith = false;
    protected List<String> patternParts;

    public static GkBeanPath create(String expression) {
        return new GkBeanPath(expression);
    }

    public GkBeanPath(String expression) {
        this.init(expression);
    }

    public Object get(Object bean) {
        return this.get(this.patternParts, bean, false);
    }

    public List<String> getPatternParts() {
        ArrayList<String> parts = new ArrayList<String>();
        for (String item : this.patternParts) {
            parts.add(item);
        }
        return parts;
    }

    public void set(Object bean, Object value) {
        this.set(bean, this.patternParts, value);
    }

    private void set(Object bean, List<String> patternParts, Object value) {
        Object subBean = this.get(patternParts, bean, true);
        if (null == subBean) {
            this.set(bean, patternParts.subList(0, patternParts.size() - 1), new HashMap());
            subBean = this.get(patternParts, bean, true);
        }
        GutilReflection.setFieldValue(subBean, patternParts.get(patternParts.size() - 1), value);
    }

    private Object get(List<String> patternParts, Object bean, boolean ignoreLast) {
        int length = patternParts.size();
        if (ignoreLast) {
            --length;
        }
        Object subBean = bean;
        boolean isFirst = true;
        for (int i = 0; i < length; ++i) {
            String patternPart = patternParts.get(i);
            if (null != (subBean = GkBeanPath.getFieldValue(subBean, patternPart))) continue;
            if (isFirst && !this.isStartWith && GkBeanPath.isMatchName(bean, patternPart, true)) {
                subBean = bean;
                isFirst = false;
                continue;
            }
            return null;
        }
        return subBean;
    }

    private static boolean isMatchName(Object bean, String beanClassName, boolean isSimple) {
        return GutilClass.getClassName(bean, isSimple).equals(isSimple ? GutilStr.upperFirst(beanClassName) : beanClassName);
    }

    private static Object getFieldValue(Object bean, String expression) {
        if (GutilStr.isBlank(expression)) {
            return null;
        }
        if (GutilStr.contains((CharSequence)expression, ':')) {
            String[] parts = GutilStr.split(expression, ":");
            int start = Integer.parseInt(parts[0]);
            int end = Integer.parseInt(parts[1]);
            int step = 1;
            if (3 == parts.length) {
                step = Integer.parseInt(parts[2]);
            }
            if (bean instanceof Collection) {
                return GkBeanPath.sub(new ArrayList((Collection)bean), start, end, step);
            }
            if (GutilArray.isArray(bean)) {
                return GutilArray.sub(bean, start, end, step);
            }
        } else {
            if (GutilStr.contains((CharSequence)expression, ',')) {
                String[] keys = GutilStr.split(expression, ",");
                if (bean instanceof Collection) {
                    int[] intKeys = new int[keys.length];
                    for (int i = 0; i < intKeys.length; ++i) {
                        intKeys[i] = Integer.parseInt(keys[i]);
                    }
                    return GkBeanPath.getAny((Collection)bean, intKeys);
                }
                if (GutilArray.isArray(bean)) {
                    int[] intKeys = new int[keys.length];
                    for (int i = 0; i < intKeys.length; ++i) {
                        intKeys[i] = Integer.parseInt(keys[i]);
                    }
                    return GutilArray.getAny(bean, intKeys);
                }
                String[] unWrappedKeys = new String[keys.length];
                for (int i = 0; i < unWrappedKeys.length; ++i) {
                    unWrappedKeys[i] = GutilStr.unWrap(keys[i], '\'');
                }
                if (bean instanceof Map) {
                    Map ct = (Map)bean;
                    HashMap map = new HashMap();
                    for (String key : keys) {
                        String keyR = GutilStr.unWrap(key, '\'');
                        if (!ct.containsKey(keyR)) continue;
                        map.put(keyR, ct.get(keyR));
                    }
                    return map;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (String key : keys) {
                    String keyR = GutilStr.unWrap(key, '\'');
                    Object obj = GutilReflection.getFieldValue(bean, keyR);
                    if (obj == null) continue;
                    map.put(keyR, obj);
                }
                return map;
            }
            if (bean instanceof Map) {
                return ((Map)bean).get(expression);
            }
            if (bean instanceof Collection) {
                return GkBeanPath.getCollectionIndex((Collection)bean, Integer.parseInt(expression));
            }
            if (GutilArray.isArray(bean)) {
                return GutilArray.get(bean, Integer.parseInt(expression));
            }
            return GutilReflection.getFieldValue(bean, expression);
        }
        return null;
    }

    private static <T> T getCollectionIndex(Collection<T> collection, int index) {
        if (null == collection) {
            return null;
        }
        int size = collection.size();
        if (0 == size) {
            return null;
        }
        if (index < 0) {
            index += size;
        }
        if (index >= size) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(index);
        }
        int i = 0;
        for (T t : collection) {
            if (i > index) break;
            if (i == index) {
                return t;
            }
            ++i;
        }
        return null;
    }

    private static <T> List<T> sub(List<T> list, int start, int end, int step) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return new ArrayList(0);
        }
        int size = list.size();
        if (start < 0) {
            start += size;
        }
        if (end < 0) {
            end += size;
        }
        if (start == size) {
            return new ArrayList(0);
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > size) {
            if (start >= size) {
                return new ArrayList(0);
            }
            end = size;
        }
        if (step <= 1) {
            return list.subList(start, end);
        }
        ArrayList<T> result = new ArrayList<T>();
        for (int i = start; i < end; i += step) {
            result.add(list.get(i));
        }
        return result;
    }

    private static <T> List<T> getAny(Collection<T> collection, int ... indexes) {
        int size = collection.size();
        ArrayList<Object> result = new ArrayList<Object>();
        if (collection instanceof List) {
            List list = (List)collection;
            for (int index : indexes) {
                if (index < 0) {
                    index += size;
                }
                result.add(list.get(index));
            }
        } else {
            Object[] array = collection.toArray();
            for (int index : indexes) {
                if (index < 0) {
                    index += size;
                }
                result.add(array[index]);
            }
        }
        return result;
    }

    private void init(String expression) {
        ArrayList<String> localPatternParts = new ArrayList<String>();
        int length = expression.length();
        StringBuilder builder = new StringBuilder();
        boolean isNumStart = false;
        for (int i = 0; i < length; ++i) {
            char c = expression.charAt(i);
            if (0 == i && '$' == c) {
                this.isStartWith = true;
                continue;
            }
            if (GutilArray.contains(EXP_CHARS, c)) {
                if (']' == c) {
                    if (!isNumStart) {
                        throw new IllegalArgumentException(GutilStr.format((CharSequence)"Bad expression '{}':{}, we find ']' but no '[' !", expression, i));
                    }
                    isNumStart = false;
                } else {
                    if (isNumStart) {
                        throw new IllegalArgumentException(GutilStr.format((CharSequence)"Bad expression '{}':{}, we find '[' but no ']' !", expression, i));
                    }
                    if ('[' == c) {
                        isNumStart = true;
                    }
                }
                if (builder.length() > 0) {
                    localPatternParts.add(GkBeanPath.unWrapIfPossible(builder));
                }
                builder.delete(0, builder.length());
                continue;
            }
            builder.append(c);
        }
        if (isNumStart) {
            throw new IllegalArgumentException(GutilStr.format((CharSequence)"Bad expression '{}':{}, we find '[' but no ']' !", expression, length - 1));
        }
        if (builder.length() > 0) {
            localPatternParts.add(GkBeanPath.unWrapIfPossible(builder));
        }
        this.patternParts = Collections.unmodifiableList(localPatternParts);
    }

    private static String unWrapIfPossible(CharSequence expression) {
        if (GutilStr.containsAny(expression, " = ", " > ", " < ", " like ", ",")) {
            return expression.toString();
        }
        return GutilStr.unWrap(expression, '\'');
    }
}

