/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.concurrent;

import com.gw.base.concurrent.GkUnsynchronizedAppenderBase;
import com.gw.base.concurrent.InterruptUtil;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.function.Consumer;

public class GkAsyncConsumerQueue<E>
extends GkUnsynchronizedAppenderBase<E> {
    Consumer<E> consumer;
    BlockingQueue<E> blockingQueue;
    public static final int DEFAULT_QUEUE_SIZE = 256;
    int queueSize = 256;
    static final int UNDEFINED = -1;
    int discardingThreshold = -1;
    boolean neverBlock = false;
    Worker worker = new Worker();
    public static final int DEFAULT_MAX_FLUSH_TIME = 1000;
    int maxFlushTime = 1000;

    protected boolean isDiscardable(E bag) {
        return false;
    }

    protected void preprocess(E bag) {
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        if (this.consumer == null) {
            this.addError("No consumer found.");
            return;
        }
        if (this.queueSize < 1) {
            this.addError("Invalid queue size [" + this.queueSize + "]");
            return;
        }
        this.blockingQueue = new ArrayBlockingQueue(this.queueSize);
        if (this.discardingThreshold == -1) {
            this.discardingThreshold = this.queueSize / 5;
        }
        this.addInfo("Setting discardingThreshold to " + this.discardingThreshold);
        this.worker.setDaemon(true);
        this.worker.setName("AsyncAppender-Worker-" + this.getName());
        super.start();
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        this.worker.interrupt();
        InterruptUtil interruptUtil = new InterruptUtil();
        try {
            interruptUtil.maskInterruptFlag();
            this.worker.join(this.maxFlushTime);
            if (this.worker.isAlive()) {
                this.addWarn("Max queue flush timeout (" + this.maxFlushTime + " ms) exceeded. Approximately " + this.blockingQueue.size() + " queued events were possibly discarded.");
            } else {
                this.addInfo("Queue flush finished successfully within timeout.");
            }
        }
        catch (InterruptedException e) {
            int remaining = this.blockingQueue.size();
            this.addError("Failed to join worker thread. " + remaining + " queued events may be discarded.", e);
        }
        finally {
            interruptUtil.unmaskInterruptFlag();
        }
    }

    @Override
    protected void append(E bag) {
        if (this.isQueueBelowDiscardingThreshold() && this.isDiscardable(bag)) {
            return;
        }
        this.preprocess(bag);
        this.put(bag);
    }

    private boolean isQueueBelowDiscardingThreshold() {
        return this.blockingQueue.remainingCapacity() < this.discardingThreshold;
    }

    private void put(E bag) {
        if (this.neverBlock) {
            this.blockingQueue.offer(bag);
        } else {
            this.putUninterruptibly(bag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putUninterruptibly(E bag) {
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    this.blockingQueue.put(bag);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getDiscardingThreshold() {
        return this.discardingThreshold;
    }

    public void setDiscardingThreshold(int discardingThreshold) {
        this.discardingThreshold = discardingThreshold;
    }

    public int getMaxFlushTime() {
        return this.maxFlushTime;
    }

    public void setMaxFlushTime(int maxFlushTime) {
        this.maxFlushTime = maxFlushTime;
    }

    public int getNumberOfElementsInQueue() {
        return this.blockingQueue.size();
    }

    public void setNeverBlock(boolean neverBlock) {
        this.neverBlock = neverBlock;
    }

    public boolean isNeverBlock() {
        return this.neverBlock;
    }

    public int getRemainingCapacity() {
        return this.blockingQueue.remainingCapacity();
    }

    public void setConsumer(Consumer<E> newconsumer) {
        this.consumer = newconsumer;
    }

    class Worker
    extends Thread {
        Worker() {
        }

        @Override
        public void run() {
            GkAsyncConsumerQueue parent = GkAsyncConsumerQueue.this;
            Consumer cs = parent.consumer;
            while (parent.isStarted()) {
                try {
                    Object e = parent.blockingQueue.take();
                    cs.accept(e);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                    break;
                }
            }
            GkAsyncConsumerQueue.this.addInfo("Worker thread will flush remaining events before exiting. ");
            for (Object e : parent.blockingQueue) {
                cs.accept(e);
                parent.blockingQueue.remove(e);
            }
        }
    }
}

