/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.concurrent;

public abstract class GkUnsynchronizedAppenderBase<E> {
    protected boolean started = false;
    private ThreadLocal<Boolean> guard = new ThreadLocal();
    protected String name;
    private int statusRepeatCount = 0;
    private int exceptionCount = 0;
    static final int ALLOWED_REPEATS = 3;

    public String getName() {
        return this.name;
    }

    public void doAppend(E bag) {
        if (Boolean.TRUE.equals(this.guard.get())) {
            return;
        }
        try {
            this.guard.set(Boolean.TRUE);
            if (!this.started) {
                if (this.statusRepeatCount++ < 3) {
                    this.addStatus("Attempted to append to non started appender [" + this.name + "].");
                }
                return;
            }
            this.append(bag);
        }
        catch (Exception e) {
            if (this.exceptionCount++ < 3) {
                this.addError("Appender [" + this.name + "] failed to append.");
            }
        }
        finally {
            this.guard.set(Boolean.FALSE);
        }
    }

    protected abstract void append(E var1);

    public void setName(String name) {
        this.name = name;
    }

    public void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.name + "]";
    }

    protected void addInfo(String msg) {
        System.out.println(msg);
    }

    protected void addError(String msg) {
        System.out.println(msg);
    }

    protected void addError(String msg, Exception e) {
        e.printStackTrace(System.out);
    }

    protected void addStatus(String msg) {
        System.out.println(msg);
    }

    protected void addWarn(String msg) {
        System.out.println(msg);
    }
}

