/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.lang;

import com.gw.base.util.GutilType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GkActualTypeMapperPool {
    private static final ConcurrentHashMap<Type, Map<Type, Type>> CACHE = new ConcurrentHashMap();

    public static Map<Type, Type> get(Type type) {
        Map<Type, Type> res = CACHE.get(type);
        if (res == null) {
            res = GkActualTypeMapperPool.createTypeMap(type);
            CACHE.put(type, res);
        }
        return res;
    }

    public static Type getActualType(Type type, TypeVariable<?> typeVariable) {
        Map<Type, Type> typeTypeMap = GkActualTypeMapperPool.get(type);
        Type result = typeTypeMap.get(typeVariable);
        while (result instanceof TypeVariable) {
            result = typeTypeMap.get(result);
        }
        return result;
    }

    public static Type[] getActualTypes(Type type, Type ... typeVariables) {
        Type[] result = new Type[typeVariables.length];
        for (int i = 0; i < typeVariables.length; ++i) {
            result[i] = typeVariables[i] instanceof TypeVariable ? GkActualTypeMapperPool.getActualType(type, (TypeVariable)typeVariables[i]) : typeVariables[i];
        }
        return result;
    }

    private static Map<Type, Type> createTypeMap(Type type) {
        ParameterizedType parameterizedType;
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        while (null != type && null != (parameterizedType = GutilType.toParameterizedType(type))) {
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            Class rawType = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                typeMap.put(typeParameters[i], typeArguments[i]);
            }
            type = rawType;
        }
        return typeMap;
    }
}

