/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.lang.caller;

import com.gw.base.lang.caller.GkCaller;
import com.gw.base.util.GutilStr;
import java.io.Serializable;

public class GkStackTraceCaller
implements GkCaller,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int OFFSET = 2;

    @Override
    public Class<?> getCaller() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        if (3 >= stackTrace.length) {
            return null;
        }
        String className = stackTrace[3].getClassName();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(GutilStr.format((CharSequence)"[{}] not found!", className), e);
        }
    }

    @Override
    public String getCallerName() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        if (3 >= stackTrace.length) {
            return null;
        }
        return stackTrace[3].getClassName();
    }

    @Override
    public Class<?> getCallerCaller() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        if (4 >= stackTrace.length) {
            return null;
        }
        String className = stackTrace[4].getClassName();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(GutilStr.format((CharSequence)"[{}] not found!", className), e);
        }
    }

    @Override
    public String getCallerCallerName() {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        if (4 >= stackTrace.length) {
            return null;
        }
        return stackTrace[4].getClassName();
    }

    @Override
    public Class<?> getCaller(int depth) {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        if (2 + depth >= stackTrace.length) {
            return null;
        }
        String className = stackTrace[2 + depth].getClassName();
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(GutilStr.format((CharSequence)"[{}] not found!", className), e);
        }
    }

    @Override
    public String getCallerName(int depth) {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        if (2 + depth >= stackTrace.length) {
            return null;
        }
        return stackTrace[2 + depth].getClassName();
    }

    @Override
    public boolean isCalledBy(Class<?> clazz) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement element : stackTrace = new Throwable().getStackTrace()) {
            if (!element.getClassName().equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }
}

