/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.lang.invoke;

import com.gw.base.lang.invoke.GaMethodHandDefine;
import com.gw.base.lang.invoke.GaMethodHandImpl;
import com.gw.base.tool.GkConsole;
import com.gw.base.util.GutilClass;
import com.gw.base.util.GutilReflection;
import com.gw.base.util.GutilStr;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class GkMethodHand {
    private static Map<String, GkMethodHand> setups = new ConcurrentHashMap<String, GkMethodHand>();
    private static Map<String, String> selfs = new ConcurrentHashMap<String, String>();
    private String id;
    private MethodType methodType;
    private Map<String, Define> defines = new HashMap<String, Define>();
    private Map<String, Impl> impls = new HashMap<String, Impl>();
    private Impl impl = null;
    private String setupCallerId;

    private static String formatMethodDesc(Method method) {
        StringBuffer sb = new StringBuffer().append(method.getDeclaringClass().getName()).append(".").append(method.getName()).append("(");
        for (Class<?> pt : method.getParameterTypes()) {
            sb.append(pt.getSimpleName()).append(",");
        }
        if (sb.lastIndexOf(",") == sb.length() - 1) {
            return sb.replace(sb.length() - 1, sb.length(), ")").toString();
        }
        return sb.append(")").toString();
    }

    private static String getMethodHandleId(Method method) {
        GaMethodHandDefine conf = method.getAnnotation(GaMethodHandDefine.class);
        if (conf != null && !GutilStr.isBlank(conf.id())) {
            return conf.id();
        }
        return GkMethodHand.formatMethodDesc(method);
    }

    private static String getCallerIdByStackTraceElement(StackTraceElement ste) {
        return new StringBuffer().append(ste.getClassName()).append(".").append(ste.getMethodName()).append("(").append(ste.getFileName()).append(":").append(ste.getLineNumber()).append(")").toString();
    }

    private static StackTraceElement getCallerStackTraceElement() {
        StackTraceElement[] stes;
        for (StackTraceElement ste : stes = Thread.currentThread().getStackTrace()) {
            if (ste.getClassName().equals(Thread.class.getName()) || ste.getClassName().equals(GkMethodHand.class.getName())) continue;
            return ste;
        }
        return null;
    }

    private static String getCallerId() {
        return GkMethodHand.getCallerIdByStackTraceElement(GkMethodHand.getCallerStackTraceElement());
    }

    private static boolean matchType(Object[] args, Class<?>[] types) {
        int len = args.length;
        if (len == types.length) {
            for (int i = 0; i < len; ++i) {
                if (args[i] == null || GutilClass.resolvePrimitiveIfNecessary(types[i]).isAssignableFrom(args[i].getClass())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static synchronized GkMethodHand setup(String handleId) {
        if (setups.containsKey(handleId)) {
            return setups.get(handleId);
        }
        GkMethodHand hand = new GkMethodHand(handleId);
        setups.put(handleId, hand);
        return hand;
    }

    public static void defineFromClass(Class<?> clz) {
        Method[] methods;
        for (Method method : methods = clz.getDeclaredMethods()) {
            GaMethodHandDefine conf = method.getAnnotation(GaMethodHandDefine.class);
            if (conf == null) continue;
            GkMethodHand.defineFromMethod(method);
        }
    }

    public static GkMethodHand defineFromMethod(Method method) {
        GaMethodHandDefine conf = method.getAnnotation(GaMethodHandDefine.class);
        if (conf == null) {
            return GkMethodHand.define(GkMethodHand.getMethodHandleId(method), method.getReturnType(), method.getParameterTypes());
        }
        return GkMethodHand.define(GkMethodHand.getMethodHandleId(method), GutilStr.emptyToDefault(conf.expectClassName(), null), GutilStr.emptyToDefault(conf.expectMethodName(), method.getName()), method.getReturnType(), method.getParameterTypes());
    }

    public static GkMethodHand define(String handleId, Class<?> returnType, Class<?> ... parameterTypes) {
        return GkMethodHand.define(handleId, null, null, returnType, parameterTypes);
    }

    private static GkMethodHand define(String handleId, String expectClassName, String expectMethodName, Class<?> returnType, Class<?> ... parameterTypes) {
        GkMethodHand rh = GkMethodHand.setup(handleId);
        rh.addDefine(MethodType.methodType(returnType, parameterTypes), expectClassName, expectMethodName);
        return rh;
    }

    public static void implFromClass(Class<?> clz) {
        Method[] methods;
        for (Method method : methods = clz.getDeclaredMethods()) {
            if (method.getAnnotation(GaMethodHandImpl.class) == null) continue;
            GkMethodHand.implFromMethod(method);
        }
    }

    public static void implFromMethod(Method method) {
        String implId;
        GaMethodHandImpl conf = method.getAnnotation(GaMethodHandImpl.class);
        if (conf != null) {
            implId = conf.id();
            if (GutilStr.isEmpty(implId)) {
                Class<?> implClass = conf.implClass();
                Method md = null;
                try {
                    md = implClass.getDeclaredMethod(GutilStr.emptyToDefault(conf.implMethod(), method.getName()), method.getParameterTypes());
                }
                catch (Exception e) {
                    throw new IllegalStateException("GkMethodHand.implFromMethod(Method)\u53d1\u751f\u9519\u8bef,\u6240\u9700\u8981\u5b9e\u73b0\u7684\u7c7b\u4e2d\u6ca1\u6709\u627e\u5230\u65b9\u6cd5:" + method.toString(), e);
                }
                implId = GkMethodHand.getMethodHandleId(md);
            }
        } else {
            throw new IllegalStateException("GkMethodHand.implFromMethod(Method)\u53d1\u751f\u9519\u8bef,\u65b9\u6cd5\u5fc5\u987b\u5e26\u6709GaMethodHandImpl\u6ce8\u89e3," + method.toString());
        }
        GkMethodHand.impl(implId, method, conf.type());
    }

    public static void impl(String handleId, Method method, GaMethodHandImpl.ImplType implType) {
        GkMethodHand.setup(handleId).addImpl(method, null, implType);
    }

    public static void appoint(String handleId, MethodHandle methodHandle) {
        GkMethodHand rmh = GkMethodHand.setup(handleId);
        Impl imp = rmh.addImpl(null, methodHandle, GaMethodHandImpl.ImplType.cover);
        imp.isAppoint = true;
        rmh.impl = imp;
    }

    public static void prints(String flag) {
        for (Map.Entry<String, GkMethodHand> ent : setups.entrySet()) {
            GkConsole.log("GkMethodHand print --------------------------------------------------start-------------------------------------------------------" + flag);
            ent.getValue().print();
            GkConsole.log("GkMethodHand print ---------------------------------------------------end------------------------------------------------------" + flag);
        }
    }

    public static GkMethodHand get(String handleId) {
        return setups.get(handleId);
    }

    public static <T> T invokeHandle(String handleId, Class<T> returnType, Object ... args) {
        return (T)GkMethodHand.get(handleId).invoke(args);
    }

    public static Object invokeHandle(String handleId, Object ... args) {
        return GkMethodHand.get(handleId).invoke(args);
    }

    public static Object invokeSelf(Object ... args) {
        Method[] methods;
        StackTraceElement ste = GkMethodHand.getCallerStackTraceElement();
        String selfId = GkMethodHand.getCallerIdByStackTraceElement(ste);
        if (selfs.containsKey(selfId)) {
            String handleId = selfs.get(selfId);
            return setups.get(handleId).invoke(args);
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(ste.getClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        for (Method md : methods = clazz.getDeclaredMethods()) {
            if (!md.getName().equals(ste.getMethodName()) || !GkMethodHand.matchType(args, md.getParameterTypes())) continue;
            String testId = GkMethodHand.getMethodHandleId(md);
            GkMethodHand mh = null;
            if (setups.containsKey(testId)) {
                mh = GkMethodHand.defineFromMethod(md);
                mh = setups.get(testId);
            } else {
                mh = GkMethodHand.defineFromMethod(md);
            }
            selfs.put(selfId, testId);
            Object rtn = mh.invoke(args);
            return rtn;
        }
        throw new IllegalStateException(GutilStr.format((CharSequence)"GkMethodHand.invokeSelf(Object...)\u6267\u884c\u5931\u8d25,\u53ef\u80fd\u7684\u539f\u56e0\u662f\u65b9\u6cd5\u53c2\u6570\u4e2a\u6570\u4e0e\u58f0\u660e\u65b9\u6cd5\u53c2\u6570\u4e2a\u6570\u4e0d\u4e00\u81f4 at {}", selfId));
    }

    public void print() {
        GkConsole.log("GkMethodHand{");
        GkConsole.log("  id:" + this.id);
        GkConsole.log("  setupCallerId: at " + this.setupCallerId);
        GkConsole.log("  methodType:" + this.methodType.toString());
        GkConsole.log("  impl:" + (this.impl == null ? null : this.impl.implId));
        GkConsole.log("  defines:[");
        for (Define df : this.defines.values()) {
            df.print();
        }
        GkConsole.log("  ]");
        GkConsole.log("  impls:[");
        for (Impl ip : this.impls.values()) {
            ip.print();
        }
        GkConsole.log("  ]");
        GkConsole.log("}");
    }

    private GkMethodHand(String id) {
        this.id = id;
        this.setupCallerId = GkMethodHand.getCallerId();
    }

    private String getMyCallerId() {
        return GkMethodHand.getCallerId() + this.getId();
    }

    public String getId() {
        return this.id;
    }

    public ImplStatus getImplStatus() {
        if (this.impl == null) {
            return ImplStatus.empty;
        }
        if (this.impl.isExpect()) {
            if (this.impl.isAppoint) {
                return ImplStatus.appointed_expected;
            }
            return ImplStatus.expected;
        }
        if (this.impl.isAppoint) {
            return ImplStatus.appointed;
        }
        return ImplStatus.other;
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    public Object invoke(Object ... args) {
        Object[] lastArray;
        MethodHandle mh = this.getMethodHandle();
        if (mh == null) {
            throw new IllegalStateException("GkMethodHand(" + this.getId() + ").invoke(Object...)\u6ca1\u6709\u5bf9\u5e94\u7684\u5b9e\u73b0 at " + GkMethodHand.getCallerId());
        }
        if (mh.isVarargsCollector() && (lastArray = (Object[])args[args.length - 1]) != null && lastArray.length > 0) {
            Object[] argsVal = new Object[args.length + lastArray.length - 1];
            System.arraycopy(args, 0, argsVal, 0, args.length - 1);
            System.arraycopy(lastArray, 0, argsVal, args.length - 1, lastArray.length);
            try {
                return mh.invokeWithArguments(argsVal);
            }
            catch (Throwable e) {
                throw new IllegalStateException("GkMethodHand(" + this.getId() + ").invoke(Object...)\u53d1\u751f\u9519\u8bef at " + GkMethodHand.getCallerId(), e);
            }
        }
        try {
            int len = args.length;
            if (len == 0) {
                return mh.invoke();
            }
            return mh.invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw new IllegalStateException("GkMethodHand(" + this.getId() + ").invoke(Object...)\u53d1\u751f\u9519\u8bef at " + GkMethodHand.getCallerId(), e);
        }
    }

    private Impl addImpl(Method method, MethodHandle methodHandle, GaMethodHandImpl.ImplType implType) {
        String key = this.getMyCallerId();
        if (!this.impls.containsKey(key)) {
            Impl imp = new Impl(key, method, methodHandle, implType);
            this.impls.put(key, imp);
            this.setMethodType(imp.methodHandle.type());
            if (this.impl == null) {
                this.impl = imp;
            } else if (!this.impl.isAppoint) {
                if (implType == GaMethodHandImpl.ImplType.cover) {
                    this.impl = imp;
                } else if (implType == GaMethodHandImpl.ImplType.expectfirst && !this.impl.isExpect()) {
                    this.impl = imp;
                }
            }
            return imp;
        }
        return this.impls.get(key);
    }

    private boolean addExpect() {
        for (Define df : this.defines.values()) {
            Method exM = df.getExpectMethod(this.methodType.parameterArray());
            if (exM == null) continue;
            Impl imp = this.addImpl(exM, null, GaMethodHandImpl.ImplType.expectfirst);
            imp.isInitExpect = true;
            return true;
        }
        return false;
    }

    private boolean addDefine(MethodType methodType, String expectClassName, String expectMethodName) {
        String key = this.getMyCallerId();
        if (!this.defines.containsKey(key)) {
            Define define = new Define(key, expectClassName, expectMethodName);
            this.defines.put(key, define);
            this.setMethodType(methodType);
            return true;
        }
        return false;
    }

    private GkMethodHand setMethodType(MethodType methodType) {
        if (this.methodType == null) {
            this.methodType = methodType;
        } else if (!this.methodType.equals((Object)methodType)) {
            throw new IllegalStateException("GkMethodHand.setMethodType(MethodType)\u8bbe\u7f6e\u4e86\u4e0d\u540c\u7684methodType at " + GkMethodHand.getCallerId());
        }
        return this;
    }

    public MethodHandle getMethodHandle() {
        if (this.impl == null || !this.impl.isInitExpect) {
            this.addExpect();
        }
        if (this.impl == null) {
            return null;
        }
        return this.impl.methodHandle;
    }

    private class Impl {
        private String implId;
        private Method method;
        private MethodHandle methodHandle;
        private GaMethodHandImpl.ImplType implType;
        private boolean isInitExpect;
        private boolean isAppoint;

        public boolean isExpect() {
            if (this.isInitExpect) {
                return true;
            }
            for (Impl imp : GkMethodHand.this.impls.values()) {
                if (imp == this || !imp.isInitExpect || !Objects.equals(imp.method, this.method) && !Objects.equals(imp.methodHandle, this.methodHandle)) continue;
                return true;
            }
            return false;
        }

        private Impl(String implId, Method method, MethodHandle handle, GaMethodHandImpl.ImplType implType) {
            this.implId = implId;
            this.methodHandle = handle;
            this.implType = implType;
            if (method != null) {
                this.method = method;
                GutilReflection.makeAccessible(method);
                try {
                    this.methodHandle = MethodHandles.lookup().unreflect(method);
                }
                catch (Exception e) {
                    throw new IllegalStateException("GkMethodHand.Impl(Method)\u53d1\u751f\u9519\u8bef:" + GkMethodHand.getMethodHandleId(method), e);
                }
            }
        }

        public void print() {
            GkConsole.log("    {");
            GkConsole.log("      implId:at " + this.implId);
            GkConsole.log("      isInitExpect:" + this.isInitExpect);
            GkConsole.log("      isAppoint:" + this.isAppoint);
            GkConsole.log("      implType:" + (Object)((Object)this.implType));
            GkConsole.log("      method:" + this.method.getName());
            GkConsole.log("      methodHandle:" + this.methodHandle.toString());
            GkConsole.log("    }");
        }
    }

    public static enum ImplStatus {
        empty,
        expected,
        appointed,
        appointed_expected,
        other;

    }

    private class Define {
        private String defineId;
        private String expectClassName;
        private String expectMethodName;

        private Define(String defineId, String expectClassName, String expectMethodName) {
            this.defineId = defineId;
            this.expectClassName = expectClassName;
            this.expectMethodName = expectMethodName;
        }

        private Class<?> getExpectClass() {
            if (!GutilStr.isEmpty(this.expectClassName)) {
                try {
                    return Class.forName(this.expectClassName, true, Thread.currentThread().getContextClassLoader());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private Method getExpectMethod(Class<?>[] parameterTypes) {
            if (!GutilStr.isEmpty(this.expectMethodName)) {
                Class<?> clz = this.getExpectClass();
                if (clz == null) {
                    return null;
                }
                try {
                    return clz.getDeclaredMethod(this.expectMethodName, parameterTypes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public void print() {
            GkConsole.log("    {");
            GkConsole.log("      defineId:at " + this.defineId);
            GkConsole.log("      expectClassName:" + this.expectClassName);
            GkConsole.log("      expectMethodName:" + this.expectMethodName);
            GkConsole.log("    }");
        }
    }
}

