/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.log;

import com.gw.base.log.GemLogLevel;
import com.gw.base.log.GiLoger;
import com.gw.base.tool.GkConsole;
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilStr;
import java.util.Date;
import java.util.HashMap;

public class GwConsoleLog
implements GiLoger {
    private static final String logFormat = "[{date}] [{level}] {name}: {msg}";
    private final String name;
    private static GemLogLevel currentLevel = GemLogLevel.ALL;

    public static GwConsoleLog forName(String name) {
        return new GwConsoleLog(name);
    }

    public GwConsoleLog(Class<?> clazz) {
        this.name = null == clazz ? "null" : clazz.getName();
    }

    public GwConsoleLog(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static void setLevel(GemLogLevel customLevel) {
        GutilAssert.notNull((Object)customLevel, () -> "\u7ea7\u522b\u4e0d\u80fd\u4e3anull");
        currentLevel = customLevel;
    }

    public void log(GemLogLevel level, Throwable t, String format, Object ... arguments) {
        if (!this.isEnabled(level)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("date", new Date());
        map.put("level", level.toString());
        map.put("name", this.name);
        map.put("msg", GutilStr.format((CharSequence)format, arguments));
        String logMsg = GutilStr.format((CharSequence)logFormat, map);
        if (level.ordinal() >= GemLogLevel.WARN.ordinal()) {
            GkConsole.error(t, logMsg, new Object[0]);
        } else {
            GkConsole.log(t, logMsg, new Object[0]);
        }
    }

    public boolean isEnabled(GemLogLevel level) {
        return currentLevel.compareTo(level) <= 0;
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isEnabled(GemLogLevel.FATAL);
    }

    @Override
    public void fatal(String format, Object ... arguments) {
        this.log(GemLogLevel.FATAL, null, format, arguments);
    }

    @Override
    public void fatal(Throwable t) {
        this.log(GemLogLevel.FATAL, t, null, new Object[0]);
    }

    @Override
    public void fatal(Throwable t, String format, Object ... arguments) {
        this.log(GemLogLevel.FATAL, t, format, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabled(GemLogLevel.ERROR);
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        this.log(GemLogLevel.ERROR, t, format, arguments);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.log(GemLogLevel.ERROR, null, format, arguments);
    }

    @Override
    public void error(Throwable t) {
        this.log(GemLogLevel.ERROR, t, null, new Object[0]);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabled(GemLogLevel.WARN);
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        this.log(GemLogLevel.WARN, t, format, arguments);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.log(GemLogLevel.WARN, null, format, arguments);
    }

    @Override
    public void warn(Throwable t) {
        this.log(GemLogLevel.WARN, t, null, new Object[0]);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabled(GemLogLevel.INFO);
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        this.log(GemLogLevel.INFO, t, format, arguments);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.log(GemLogLevel.INFO, null, format, arguments);
    }

    @Override
    public void info(Throwable t) {
        this.log(GemLogLevel.INFO, t, null, new Object[0]);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(GemLogLevel.DEBUG);
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        this.log(GemLogLevel.DEBUG, t, format, arguments);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.log(GemLogLevel.DEBUG, null, format, arguments);
    }

    @Override
    public void debug(Throwable t) {
        this.log(GemLogLevel.DEBUG, t, null, new Object[0]);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isEnabled(GemLogLevel.TRACE);
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        this.log(GemLogLevel.TRACE, t, format, arguments);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.log(GemLogLevel.TRACE, null, format, arguments);
    }

    @Override
    public void trace(Throwable t) {
        this.log(GemLogLevel.TRACE, t, null, new Object[0]);
    }
}

