/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.sp;

import com.gw.base.sp.GkSpLoader;
import com.gw.base.tool.GkConcurrentReferenceHashMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public abstract class GwCacheSpLoader
implements GkSpLoader {
    private final Map<String, Object> entityCacheMap = new GkConcurrentReferenceHashMap<String, Object>();
    private final ReentrantLock LOCK = new ReentrantLock();

    public static String strKeyForClassAndTypes(Class<?> cls, Type[] types) {
        String key = cls.getName();
        if (types != null && types.length > 0) {
            for (Type type : types) {
                key = key + "-" + type.getTypeName();
            }
        }
        return key;
    }

    @Override
    public <T> T load(Class<T> cls, Type[] types) {
        String key = this.cacheKey(cls, types);
        Object obj = this.entityCacheMap.get(key);
        if (obj != null) {
            return (T)obj;
        }
        return null;
    }

    public <T> void setCache(Class<T> cls, Type[] types, T t) {
        String key = this.cacheKey(cls, types);
        this.entityCacheMap.put(key, t);
    }

    public String cacheKey(Class<?> cls, Type[] types) {
        return GwCacheSpLoader.strKeyForClassAndTypes(cls, types);
    }
}

