/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.sp;

import com.gw.base.exception.GwException;
import com.gw.base.sp.GkSP;
import com.gw.base.sp.GwCacheSpLoader;
import com.gw.base.util.GutilArray;
import com.gw.base.util.GutilClass;
import com.gw.base.util.GutilGenericType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class GwPlaceHolderSpLoader
extends GwCacheSpLoader {
    private static final Map<Class<?>, Class<?>[]> PLACEHOLDERCLASS_CACHE = new ConcurrentHashMap();
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final Map<String, Class<?>[]> PLACEHOLDERCLASS_TYPE_CACHE = new ConcurrentHashMap<String, Class<?>[]>();
    private static final ReentrantLock LOCK_TYPE = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Class<? extends T>[] getPlaceHolderClasses(Class<T> requiredType) {
        GkSP spiAn = requiredType.getAnnotation(GkSP.class);
        if (spiAn == null) {
            throw new GwException("\u83b7\u53d6sp\u5b9e\u73b0\u7684\u63a5\u53e3\u5fc5\u987b\u5305\u542bGkSP\u6ce8\u89e3\uff1a{} ", requiredType.getName());
        }
        Class<?>[] ts = null;
        if (PLACEHOLDERCLASS_CACHE.containsKey(requiredType)) {
            ts = PLACEHOLDERCLASS_CACHE.get(requiredType);
        } else {
            LOCK.lock();
            try {
                for (Class<?> t : ts = spiAn.placeHolderClass()) {
                    if (requiredType.isAssignableFrom(t)) continue;
                    throw new GwException("\u7c7b {} \u914d\u7f6esp \u9ed8\u8ba4placeHolderClass\u5b9e\u73b0\u7c7b \uff1a{} \u7c7b\u578b\u4e0d\u5339\u914d", requiredType.getName(), t.getName());
                }
                String[] clsNames = spiAn.placeHolder();
                if (clsNames.length > 0) {
                    Class[] cls2 = new Class[clsNames.length];
                    for (int i = 0; i < clsNames.length; ++i) {
                        try {
                            cls2[i] = GutilClass.forName(clsNames[i], null);
                        }
                        catch (Exception e) {
                            throw new GwException(e, "\u7c7b {} \u914d\u7f6esp \u9ed8\u8ba4placeHolder\u5b9e\u73b0\u7c7b \uff1a{} \u672a\u627e\u5230", requiredType.getName(), clsNames[i]);
                        }
                        if (requiredType.isAssignableFrom(cls2[i])) continue;
                        throw new GwException("\u7c7b {} \u914d\u7f6esp \u9ed8\u8ba4placeHolder\u5b9e\u73b0\u7c7b \uff1a{} \u7c7b\u578b\u4e0d\u5339\u914d", requiredType.getName(), clsNames[i]);
                    }
                    ts = GutilArray.addAll(cls2, spiAn.placeHolderClass());
                }
                PLACEHOLDERCLASS_CACHE.put(requiredType, ts);
            }
            finally {
                LOCK.unlock();
            }
        }
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Class<? extends T>[] getPlaceHolderClasses(Class<T> requiredType, Type[] types) {
        String cachekey = GwPlaceHolderSpLoader.strKeyForClassAndTypes(requiredType, types);
        Class<?>[] res = null;
        if (PLACEHOLDERCLASS_TYPE_CACHE.containsKey(cachekey)) {
            res = PLACEHOLDERCLASS_TYPE_CACHE.get(cachekey);
        } else {
            LOCK_TYPE.lock();
            try {
                Class<T>[] ts = GwPlaceHolderSpLoader.getPlaceHolderClasses(requiredType);
                res = new Class[]{};
                block3: for (Class<T> t : ts) {
                    Type[] genericTypes = GutilGenericType.resolveTypeArguments(t, requiredType);
                    if (genericTypes == null) {
                        if (types.length != 0) continue;
                        res = GutilArray.append(res, new Class[]{t});
                        continue;
                    }
                    if (types.length != genericTypes.length) continue;
                    for (int i = 0; i < genericTypes.length; ++i) {
                        if (genericTypes[i] != types[i]) continue block3;
                    }
                    res = GutilArray.append(res, new Class[]{t});
                }
                PLACEHOLDERCLASS_TYPE_CACHE.put(cachekey, res);
            }
            finally {
                LOCK_TYPE.unlock();
            }
        }
        return res;
    }

    @Override
    public <T> T load(Class<T> requiredType, Type[] types) {
        Class<T>[] phClzs;
        int len;
        GkSP spiAn = requiredType.getAnnotation(GkSP.class);
        if (spiAn == null) {
            throw new GwException("\u83b7\u53d6sp\u5b9e\u73b0\u7684\u63a5\u53e3\u5fc5\u987b\u5305\u542bGkSP\u6ce8\u89e3\uff1a{} ", requiredType.getName());
        }
        Object res = null;
        if (spiAn.singleton()) {
            res = super.load(requiredType, types);
        }
        if (res == null && (len = (phClzs = GwPlaceHolderSpLoader.getPlaceHolderClasses(requiredType, types)).length) > 0) {
            if (phClzs.length != 1) {
                throw new GwException("\u7c7b {} \u914d\u7f6esp \u9ed8\u8ba4placeHolder\u53d1\u73b0\u591a\u4e2a\u5b9e\u73b0\u7c7b", requiredType.getName());
            }
            Class<T> cls = phClzs[0];
            try {
                res = cls.newInstance();
            }
            catch (Exception e) {
                throw new GwException(e, "\u7c7b {} \u914d\u7f6esp \u9ed8\u8ba4placeHolder\u5b9e\u73b0\u7c7b \uff1a{} \u5b9e\u4f8b\u5316\u5bf9\u8c61\u53d1\u751f\u9519\u8bef", requiredType.getName(), cls.getName());
            }
        }
        if (res != null && spiAn.singleton()) {
            this.setCache(requiredType, types, res);
        }
        return res;
    }
}

