/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.sp;

import com.gw.base.exception.GwException;
import com.gw.base.sp.GkSP;
import com.gw.base.sp.GkSpLoader;
import com.gw.base.sp.GwPlaceHolderSpLoader;
import com.gw.base.tool.GkConcurrentReferenceHashMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GwSpHelper {
    private static final Map<Class<? extends GkSpLoader>, GkSpLoader> LOADER_CACHE = new ConcurrentHashMap<Class<? extends GkSpLoader>, GkSpLoader>();
    private static final Map<Class<?>, Object> entityTableMap = new GkConcurrentReferenceHashMap();

    private GwSpHelper() {
    }

    private static GkSpLoader getGkSpiLoader(Class<? extends GkSpLoader> loaderClass) {
        return LOADER_CACHE.computeIfAbsent(loaderClass, c -> {
            try {
                return (GkSpLoader)c.newInstance();
            }
            catch (Exception e) {
                throw new GwException(e, "\u521b\u5efaGkSpLoader\u53d1\u751f\u9519\u8bef\uff1a{} ", loaderClass.getName());
            }
        });
    }

    public static <T> T load(Class<T> requiredType, Type ... types) {
        GkSP spiAn = requiredType.getAnnotation(GkSP.class);
        if (spiAn == null) {
            throw new GwException("\u83b7\u53d6sp\u5b9e\u73b0\u7684\u63a5\u53e3\u5fc5\u987b\u5305\u542bGkSP\u6ce8\u89e3\uff1a{} ", requiredType.getName());
        }
        Object res = null;
        if (spiAn.singleton()) {
            res = entityTableMap.get(requiredType);
        }
        if (res == null) {
            Class<? extends GkSpLoader> loader;
            Class<? extends GkSpLoader>[] loaders;
            Class<? extends GkSpLoader>[] classArray = loaders = spiAn.loader();
            int n = classArray.length;
            for (int i = 0; i < n && (res = GwSpHelper.getGkSpiLoader(loader = classArray[i]).load(requiredType, types)) == null; ++i) {
            }
            if (res == null) {
                res = GwSpHelper.getGkSpiLoader(GwPlaceHolderSpLoader.class).load(requiredType, types);
            }
        }
        return (T)res;
    }

    public static <T> T load(String name, Class<T> requiredType) {
        return null;
    }
}

