/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.tool;

import com.gw.base.tool.GkConsoleTable;
import com.gw.base.util.GutilArray;
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilStr;
import java.util.Scanner;

public class GkConsole {
    private static final String TEMPLATE_VAR = "{}";

    public static void log() {
        System.out.println();
    }

    public static void log(Object obj) {
        if (obj instanceof Throwable) {
            Throwable e = (Throwable)obj;
            GkConsole.log(e, e.getMessage(), new Object[0]);
        } else {
            GkConsole.log(TEMPLATE_VAR, obj);
        }
    }

    public static void log(Object obj1, Object ... otherObjs) {
        if (GutilArray.isEmpty(otherObjs)) {
            GkConsole.log(obj1);
        } else {
            GkConsole.log(GkConsole.buildTemplateSplitBySpace(otherObjs.length + 1), GutilArray.insert(otherObjs, 0, obj1));
        }
    }

    public static void log(String template, Object ... values) {
        if (GutilArray.isEmpty(values) || GutilStr.contains((CharSequence)template, TEMPLATE_VAR)) {
            GkConsole.logInternal(template, values);
        } else {
            GkConsole.logInternal(GkConsole.buildTemplateSplitBySpace(values.length + 1), GutilArray.insert(values, 0, new Object[]{template}));
        }
    }

    public static void log(Throwable t, String template, Object ... values) {
        System.out.println(GutilStr.format((CharSequence)template, values));
        if (null != t) {
            t.printStackTrace();
            System.out.flush();
        }
    }

    private static void logInternal(String template, Object ... values) {
        GkConsole.log(null, template, values);
    }

    public static void table(GkConsoleTable consoleTable) {
        GkConsole.print(consoleTable.toString());
    }

    public static void print(Object obj) {
        GkConsole.print(TEMPLATE_VAR, obj);
    }

    public static void print(Object obj1, Object ... otherObjs) {
        if (GutilArray.isEmpty(otherObjs)) {
            GkConsole.print(obj1);
        } else {
            GkConsole.print(GkConsole.buildTemplateSplitBySpace(otherObjs.length + 1), GutilArray.insert(otherObjs, 0, obj1));
        }
    }

    public static void print(String template, Object ... values) {
        if (GutilArray.isEmpty(values) || GutilStr.contains((CharSequence)template, TEMPLATE_VAR)) {
            GkConsole.printInternal(template, values);
        } else {
            GkConsole.printInternal(GkConsole.buildTemplateSplitBySpace(values.length + 1), GutilArray.insert(values, 0, new Object[]{template}));
        }
    }

    public static void printProgress(char showChar, int len) {
        GkConsole.print("{}{}", Character.valueOf('\r'), GutilStr.repeat(showChar, len));
    }

    public static void printProgress(char showChar, int totalLen, double rate) {
        GutilAssert.isTrue(rate >= 0.0 && rate <= 1.0, "Rate must between 0 and 1 (both include)");
        GkConsole.printProgress(showChar, (int)((double)totalLen * rate));
    }

    private static void printInternal(String template, Object ... values) {
        System.out.print(GutilStr.format((CharSequence)template, values));
    }

    public static void error() {
        System.err.println();
    }

    public static void error(Object obj) {
        if (obj instanceof Throwable) {
            Throwable e = (Throwable)obj;
            GkConsole.error(e, e.getMessage(), new Object[0]);
        } else {
            GkConsole.error(TEMPLATE_VAR, obj);
        }
    }

    public static void error(Object obj1, Object ... otherObjs) {
        if (GutilArray.isEmpty(otherObjs)) {
            GkConsole.error(obj1);
        } else {
            GkConsole.error(GkConsole.buildTemplateSplitBySpace(otherObjs.length + 1), GutilArray.insert(otherObjs, 0, obj1));
        }
    }

    public static void error(String template, Object ... values) {
        if (GutilArray.isEmpty(values) || GutilStr.contains((CharSequence)template, TEMPLATE_VAR)) {
            GkConsole.errorInternal(template, values);
        } else {
            GkConsole.errorInternal(GkConsole.buildTemplateSplitBySpace(values.length + 1), GutilArray.insert(values, 0, new Object[]{template}));
        }
    }

    public static void error(Throwable t, String template, Object ... values) {
        System.err.println(GutilStr.format((CharSequence)template, values));
        if (null != t) {
            t.printStackTrace(System.err);
            System.err.flush();
        }
    }

    private static void errorInternal(String template, Object ... values) {
        GkConsole.error(null, template, values);
    }

    public static Scanner scanner() {
        return new Scanner(System.in);
    }

    public static String input() {
        return GkConsole.scanner().next();
    }

    public static String where() {
        StackTraceElement stackTraceElement = new Throwable().getStackTrace()[1];
        String className = stackTraceElement.getClassName();
        String methodName = stackTraceElement.getMethodName();
        String fileName = stackTraceElement.getFileName();
        Integer lineNumber = stackTraceElement.getLineNumber();
        return String.format("%s.%s(%s:%s)", className, methodName, fileName, lineNumber);
    }

    public static Integer lineNumber() {
        return new Throwable().getStackTrace()[1].getLineNumber();
    }

    private static String buildTemplateSplitBySpace(int count) {
        return GutilStr.repeatAndJoin(TEMPLATE_VAR, count, " ");
    }
}

