/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.tool;

import com.gw.base.tool.GkSystemClock;
import com.gw.base.util.GutilStr;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.ThreadLocalRandom;

public class GkSnowflake
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static long DEFAULT_TWEPOCH = 1288834974657L;
    public static long DEFAULT_TIME_OFFSET = 2000L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long MAX_WORKER_ID = 31L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long MAX_DATA_CENTER_ID = 31L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private final long twepoch;
    private final long workerId;
    private final long dataCenterId;
    private final boolean useSystemClock;
    private final long timeOffset;
    private final long randomSequenceLimit;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public GkSnowflake(long workerId, long dataCenterId) {
        this(workerId, dataCenterId, false);
    }

    public GkSnowflake(long workerId, long dataCenterId, boolean isUseSystemClock) {
        this(null, workerId, dataCenterId, isUseSystemClock);
    }

    public GkSnowflake(Date epochDate, long workerId, long dataCenterId, boolean isUseSystemClock) {
        this(epochDate, workerId, dataCenterId, isUseSystemClock, DEFAULT_TIME_OFFSET);
    }

    public GkSnowflake(Date epochDate, long workerId, long dataCenterId, boolean isUseSystemClock, long timeOffset) {
        this(epochDate, workerId, dataCenterId, isUseSystemClock, timeOffset, 0L);
    }

    public GkSnowflake(Date epochDate, long workerId, long dataCenterId, boolean isUseSystemClock, long timeOffset, long randomSequenceLimit) {
        this.twepoch = null != epochDate ? epochDate.getTime() : DEFAULT_TWEPOCH;
        this.workerId = this.checkBetween(workerId, 0L, 31L);
        this.dataCenterId = this.checkBetween(dataCenterId, 0L, 31L);
        this.useSystemClock = isUseSystemClock;
        this.timeOffset = timeOffset;
        this.randomSequenceLimit = this.checkBetween(randomSequenceLimit, 0L, 4095L);
    }

    private long checkBetween(long value, long min, long max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException(GutilStr.format((CharSequence)"The value must be between {} and {}.", min, max));
        }
        return value;
    }

    public long getWorkerId(long id) {
        return id >> 12 & 0x1FL;
    }

    public long getDataCenterId(long id) {
        return id >> 17 & 0x1FL;
    }

    public long getGenerateDateTime(long id) {
        return (id >> 22 & 0x1FFFFFFFFFFL) + this.twepoch;
    }

    public long getGenerateSequence(long id) {
        return id & 0xFFFL;
    }

    public synchronized long nextId() {
        long timestamp = this.genTime();
        if (timestamp < this.lastTimestamp) {
            if (this.lastTimestamp - timestamp < this.timeOffset) {
                timestamp = this.lastTimestamp;
            } else {
                throw new IllegalStateException(GutilStr.format((CharSequence)"Clock moved backwards. Refusing to generate id for {}ms", this.lastTimestamp - timestamp));
            }
        }
        if (timestamp == this.lastTimestamp) {
            long sequence = this.sequence + 1L & 0xFFFL;
            if (sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
            this.sequence = sequence;
        } else {
            this.sequence = this.randomSequenceLimit > 1L ? ThreadLocalRandom.current().nextLong(this.randomSequenceLimit) : 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.twepoch << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    public String nextIdStr() {
        return Long.toString(this.nextId());
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.genTime();
        while (timestamp == lastTimestamp) {
            timestamp = this.genTime();
        }
        if (timestamp < lastTimestamp) {
            throw new IllegalStateException(GutilStr.format((CharSequence)"Clock moved backwards. Refusing to generate id for {}ms", lastTimestamp - timestamp));
        }
        return timestamp;
    }

    private long genTime() {
        return this.useSystemClock ? GkSystemClock.now() : System.currentTimeMillis();
    }
}

