/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.util;

import com.gw.base.util.GutilCollection;
import com.gw.base.util.GutilObject;
import com.gw.base.util.GutilStr;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

public abstract class GutilAssert {
    public static void state(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static void state(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalStateException(GutilAssert.nullSafeGet(messageSupplier));
        }
    }

    public static void isTrue(boolean expression, String message) {
        GutilAssert.isTrue(expression, () -> message);
    }

    public static void isTrue(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalStateException(GutilAssert.nullSafeGet(messageSupplier));
        }
    }

    public static void isNull(Object object, String message) {
        GutilAssert.isNull(object, () -> message);
    }

    public static void isNull(Object object, Supplier<String> messageSupplier) {
        if (object != null) {
            throw new IllegalStateException(GutilAssert.nullSafeGet(messageSupplier));
        }
    }

    public static void isNull(Object object) {
        GutilAssert.isNull(object, () -> "[Assertion failed] - the object argument must be null");
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object object, Supplier<String> messageSupplier) {
        if (object == null) {
            throw new IllegalStateException(GutilAssert.nullSafeGet(messageSupplier));
        }
    }

    public static void hasLength(String text, String message) {
        GutilAssert.hasLength(text, () -> message);
    }

    public static void hasLength(String text, Supplier<String> messageSupplier) {
        if (!GutilStr.hasLength(text)) {
            throw new IllegalStateException(GutilAssert.nullSafeGet(messageSupplier));
        }
    }

    public static void hasText(String text, String message) {
        GutilAssert.hasText(text, () -> message);
    }

    public static void hasText(String text, Supplier<String> messageSupplier) {
        if (!GutilStr.hasText(text)) {
            throw new IllegalStateException(GutilAssert.nullSafeGet(messageSupplier));
        }
    }

    public static void doesNotContain(String textToSearch, String substring, String message) {
        if (GutilStr.hasLength(textToSearch) && GutilStr.hasLength(substring) && textToSearch.contains(substring)) {
            throw new IllegalStateException(message);
        }
    }

    public static void doesNotContain(String textToSearch, String substring, Supplier<String> messageSupplier) {
        if (GutilStr.hasLength(textToSearch) && GutilStr.hasLength(substring) && textToSearch.contains(substring)) {
            throw new IllegalStateException(GutilAssert.nullSafeGet(messageSupplier));
        }
    }

    public static void notEmpty(Object[] array, String message) {
        GutilAssert.notEmpty(array, () -> message);
    }

    public static void notEmpty(Object[] array, Supplier<String> messageSupplier) {
        if (GutilObject.isEmpty(array)) {
            throw new IllegalStateException(GutilAssert.nullSafeGet(messageSupplier));
        }
    }

    public static void noNullElements(Object[] array, Supplier<String> messageSupplier) {
        if (array != null) {
            for (Object element : array) {
                if (element != null) continue;
                throw new IllegalStateException(GutilAssert.nullSafeGet(messageSupplier));
            }
        }
    }

    public static void notEmpty(Collection<?> collection, String message) {
        GutilAssert.notEmpty(collection, () -> message);
    }

    public static void notEmpty(Collection<?> collection, Supplier<String> messageSupplier) {
        if (GutilCollection.isEmpty(collection)) {
            throw new IllegalStateException(GutilAssert.nullSafeGet(messageSupplier));
        }
    }

    public static void notEmpty(Map<?, ?> map, String message) {
        GutilAssert.notEmpty(map, () -> message);
    }

    public static void notEmpty(Map<?, ?> map, Supplier<String> messageSupplier) {
        if (GutilCollection.isEmpty(map)) {
            throw new IllegalStateException(GutilAssert.nullSafeGet(messageSupplier));
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj, Supplier<String> messageSupplier) {
        GutilAssert.notNull(type, () -> "Type to check against must not be null");
        if (!type.isInstance(obj)) {
            GutilAssert.instanceCheckFailed(type, obj, GutilAssert.nullSafeGet(messageSupplier));
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj) {
        GutilAssert.isInstanceOf(type, obj, () -> "");
    }

    public static void isAssignable(Class<?> superType, Class<?> subType, String message) {
        GutilAssert.notNull(superType, () -> "Super type to check against must not be null");
        if (subType == null || !superType.isAssignableFrom(subType)) {
            GutilAssert.assignableCheckFailed(superType, subType, message);
        }
    }

    public static void isAssignable(Class<?> superType, Class<?> subType, Supplier<String> messageSupplier) {
        GutilAssert.notNull(superType, () -> "Super type to check against must not be null");
        if (subType == null || !superType.isAssignableFrom(subType)) {
            GutilAssert.assignableCheckFailed(superType, subType, GutilAssert.nullSafeGet(messageSupplier));
        }
    }

    public static void isAssignable(Class<?> superType, Class<?> subType) {
        GutilAssert.isAssignable(superType, subType, "");
    }

    private static void instanceCheckFailed(Class<?> type, Object obj, String msg) {
        String className = obj != null ? obj.getClass().getName() : "null";
        String result = "";
        boolean defaultMessage = true;
        if (GutilStr.hasLength(msg)) {
            if (GutilAssert.endsWithSeparator(msg)) {
                result = msg + " ";
            } else {
                result = GutilAssert.messageWithTypeName(msg, className);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result = result + "Object of class [" + className + "] must be an instance of " + type;
        }
        throw new IllegalArgumentException(result);
    }

    private static void assignableCheckFailed(Class<?> superType, Class<?> subType, String msg) {
        String result = "";
        boolean defaultMessage = true;
        if (GutilStr.hasLength(msg)) {
            if (GutilAssert.endsWithSeparator(msg)) {
                result = msg + " ";
            } else {
                result = GutilAssert.messageWithTypeName(msg, subType);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result = result + subType + " is not assignable to " + superType;
        }
        throw new IllegalArgumentException(result);
    }

    private static boolean endsWithSeparator(String msg) {
        return msg.endsWith(":") || msg.endsWith(";") || msg.endsWith(",") || msg.endsWith(".");
    }

    private static String messageWithTypeName(String msg, Object typeName) {
        return msg + (msg.endsWith(" ") ? "" : ": ") + typeName;
    }

    private static String nullSafeGet(Supplier<String> messageSupplier) {
        return messageSupplier != null ? messageSupplier.get() : null;
    }
}

