/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.util;

import com.gw.base.util.GutilObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;

public abstract class GutilCollection {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static List arrayToList(Object source) {
        return Arrays.asList(GutilObject.toObjectArray(source));
    }

    public static <E> void mergeArrayIntoCollection(Object array, Collection<E> collection) {
        Object[] arr;
        for (Object elem : arr = GutilObject.toObjectArray(array)) {
            collection.add(elem);
        }
    }

    public static <K, V> void mergePropertiesIntoMap(Properties props, Map<K, V> map) {
        if (props != null) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                Object value = props.get(key);
                if (value == null) {
                    value = props.getProperty(key);
                }
                map.put(key, value);
            }
        }
    }

    public static boolean contains(Iterator<?> iterator, Object element) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object candidate = iterator.next();
                if (!GutilObject.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean contains(Collection<T> collection, T element) {
        return GutilCollection.isNotEmpty(collection) && collection.contains(element);
    }

    public static boolean contains(Enumeration<?> enumeration, Object element) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object candidate = enumeration.nextElement();
                if (!GutilObject.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsInstance(Collection<?> collection, Object element) {
        if (collection != null) {
            for (Object candidate : collection) {
                if (candidate != element) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(Collection<?> source, Collection<?> candidates) {
        if (GutilCollection.isEmpty(source) || GutilCollection.isEmpty(candidates)) {
            return false;
        }
        for (Object candidate : candidates) {
            if (!source.contains(candidate)) continue;
            return true;
        }
        return false;
    }

    public static <E> E findFirstMatch(Collection<?> source, Collection<E> candidates) {
        if (GutilCollection.isEmpty(source) || GutilCollection.isEmpty(candidates)) {
            return null;
        }
        for (E candidate : candidates) {
            if (!source.contains(candidate)) continue;
            return candidate;
        }
        return null;
    }

    public static <T> T findValueOfType(Collection<?> collection, Class<T> type) {
        if (GutilCollection.isEmpty(collection)) {
            return null;
        }
        T value = null;
        for (Object element : collection) {
            if (type != null && !type.isInstance(element)) continue;
            if (value != null) {
                return null;
            }
            value = (T)element;
        }
        return value;
    }

    public static Object findValueOfType(Collection<?> collection, Class<?>[] types) {
        if (GutilCollection.isEmpty(collection) || GutilObject.isEmpty(types)) {
            return null;
        }
        for (Class<?> type : types) {
            Object value = GutilCollection.findValueOfType(collection, type);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static boolean hasUniqueObject(Collection<?> collection) {
        if (GutilCollection.isEmpty(collection)) {
            return false;
        }
        boolean hasCandidate = false;
        Object candidate = null;
        for (Object elem : collection) {
            if (!hasCandidate) {
                hasCandidate = true;
                candidate = elem;
                continue;
            }
            if (candidate == elem) continue;
            return false;
        }
        return true;
    }

    public static Class<?> findCommonElementType(Collection<?> collection) {
        if (GutilCollection.isEmpty(collection)) {
            return null;
        }
        Class<?> candidate = null;
        for (Object val : collection) {
            if (val == null) continue;
            if (candidate == null) {
                candidate = val.getClass();
                continue;
            }
            if (candidate == val.getClass()) continue;
            return null;
        }
        return candidate;
    }

    public static <T> T lastElement(Set<T> set) {
        if (GutilCollection.isEmpty(set)) {
            return null;
        }
        if (set instanceof SortedSet) {
            return (T)((SortedSet)set).last();
        }
        Iterator<T> it = set.iterator();
        T last = null;
        while (it.hasNext()) {
            last = it.next();
        }
        return last;
    }

    public static <T> T lastElement(List<T> list) {
        if (GutilCollection.isEmpty(list)) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <A, E extends A> A[] toArray(Enumeration<E> enumeration, A[] array) {
        ArrayList<E> elements = new ArrayList<E>();
        while (enumeration.hasMoreElements()) {
            elements.add(enumeration.nextElement());
        }
        return elements.toArray(array);
    }

    public static <E> Iterator<E> toIterator(Enumeration<E> enumeration) {
        return new EnumerationIterator<E>(enumeration);
    }

    private static class EnumerationIterator<E>
    implements Iterator<E> {
        private final Enumeration<E> enumeration;

        public EnumerationIterator(Enumeration<E> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public E next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

