/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class GutilDigest {
    private static final String MD5_ALGORITHM_NAME = "MD5";
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] md5Digest(byte[] bytes) {
        return GutilDigest.digest(MD5_ALGORITHM_NAME, bytes);
    }

    public static String md5DigestAsHex(byte[] bytes) {
        return GutilDigest.digestAsHexString(MD5_ALGORITHM_NAME, bytes);
    }

    public static StringBuilder appendMd5DigestAsHex(byte[] bytes, StringBuilder builder) {
        return GutilDigest.appendDigestAsHex(MD5_ALGORITHM_NAME, bytes, builder);
    }

    private static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Could not find MessageDigest with algorithm \"" + algorithm + "\"", ex);
        }
    }

    private static byte[] digest(String algorithm, byte[] bytes) {
        return GutilDigest.getDigest(algorithm).digest(bytes);
    }

    private static String digestAsHexString(String algorithm, byte[] bytes) {
        char[] hexDigest = GutilDigest.digestAsHexChars(algorithm, bytes);
        return new String(hexDigest);
    }

    private static StringBuilder appendDigestAsHex(String algorithm, byte[] bytes, StringBuilder builder) {
        char[] hexDigest = GutilDigest.digestAsHexChars(algorithm, bytes);
        return builder.append(hexDigest);
    }

    private static char[] digestAsHexChars(String algorithm, byte[] bytes) {
        byte[] digest = GutilDigest.digest(algorithm, bytes);
        return GutilDigest.encodeHex(digest);
    }

    private static char[] encodeHex(byte[] bytes) {
        char[] chars = new char[32];
        for (int i = 0; i < chars.length; i += 2) {
            byte b = bytes[i / 2];
            chars[i] = HEX_CHARS[b >>> 4 & 0xF];
            chars[i + 1] = HEX_CHARS[b & 0xF];
        }
        return chars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String calFileMd5(File file) {
        FileInputStream fileInputStream = null;
        try {
            int length;
            MessageDigest MD5 = MessageDigest.getInstance(MD5_ALGORITHM_NAME);
            fileInputStream = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            while ((length = fileInputStream.read(buffer)) != -1) {
                MD5.update(buffer, 0, length);
            }
            String string = new String(GutilDigest.encodeHex(MD5.digest()));
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String calFileMd5ByByte(byte[] bytes) {
        try {
            MessageDigest MD5 = MessageDigest.getInstance(MD5_ALGORITHM_NAME);
            MD5.update(bytes);
            return new String(GutilDigest.encodeHex(MD5.digest()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

