/*
 * Decompiled with CFR 0.152.
 */
package com.gw.base.util;

import com.gw.base.util.GutilArray;
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilChar;
import com.gw.base.util.GutilStr;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public abstract class GutilNumber {
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static final Set<Class<?>> STANDARD_NUMBER_TYPES;
    private static final int DEFAUT_DIV_SCALE = 10;
    private static final long[] FACTORIALS;

    public static <T extends Number> T convertNumberToTargetClass(Number number, Class<T> targetClass) throws IllegalArgumentException {
        GutilAssert.notNull((Object)number, "Number must not be null");
        GutilAssert.notNull(targetClass, "Target class must not be null");
        if (targetClass.isInstance(number)) {
            return (T)number;
        }
        if (Byte.class == targetClass) {
            long value = GutilNumber.checkedLongValue(number, targetClass);
            if (value < -128L || value > 127L) {
                GutilNumber.raiseOverflowException(number, targetClass);
            }
            return (T)Byte.valueOf(number.byteValue());
        }
        if (Short.class == targetClass) {
            long value = GutilNumber.checkedLongValue(number, targetClass);
            if (value < -32768L || value > 32767L) {
                GutilNumber.raiseOverflowException(number, targetClass);
            }
            return (T)Short.valueOf(number.shortValue());
        }
        if (Integer.class == targetClass) {
            long value = GutilNumber.checkedLongValue(number, targetClass);
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                GutilNumber.raiseOverflowException(number, targetClass);
            }
            return (T)Integer.valueOf(number.intValue());
        }
        if (Long.class == targetClass) {
            long value = GutilNumber.checkedLongValue(number, targetClass);
            return (T)Long.valueOf(value);
        }
        if (BigInteger.class == targetClass) {
            if (number instanceof BigDecimal) {
                return (T)((BigDecimal)number).toBigInteger();
            }
            return (T)BigInteger.valueOf(number.longValue());
        }
        if (Float.class == targetClass) {
            return (T)Float.valueOf(number.floatValue());
        }
        if (Double.class == targetClass) {
            return (T)Double.valueOf(number.doubleValue());
        }
        if (BigDecimal.class == targetClass) {
            return (T)new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to unsupported target class [" + targetClass.getName() + "]");
    }

    private static long checkedLongValue(Number number, Class<? extends Number> targetClass) {
        BigInteger bigInt = null;
        if (number instanceof BigInteger) {
            bigInt = (BigInteger)number;
        } else if (number instanceof BigDecimal) {
            bigInt = ((BigDecimal)number).toBigInteger();
        }
        if (bigInt != null && (bigInt.compareTo(LONG_MIN) < 0 || bigInt.compareTo(LONG_MAX) > 0)) {
            GutilNumber.raiseOverflowException(number, targetClass);
        }
        return number.longValue();
    }

    private static void raiseOverflowException(Number number, Class<?> targetClass) {
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to target class [" + targetClass.getName() + "]: overflow");
    }

    public static <T extends Number> T parseNumber(String text, Class<T> targetClass) {
        GutilAssert.notNull((Object)text, "Text must not be null");
        GutilAssert.notNull(targetClass, "Target class must not be null");
        String trimmed = GutilStr.trimAllWhitespace(text);
        if (Byte.class == targetClass) {
            return (T)(GutilNumber.isHexNumber(trimmed) ? Byte.decode(trimmed) : Byte.valueOf(trimmed));
        }
        if (Short.class == targetClass) {
            return (T)(GutilNumber.isHexNumber(trimmed) ? Short.decode(trimmed) : Short.valueOf(trimmed));
        }
        if (Integer.class == targetClass) {
            return (T)(GutilNumber.isHexNumber(trimmed) ? Integer.decode(trimmed) : Integer.valueOf(trimmed));
        }
        if (Long.class == targetClass) {
            return (T)(GutilNumber.isHexNumber(trimmed) ? Long.decode(trimmed) : Long.valueOf(trimmed));
        }
        if (BigInteger.class == targetClass) {
            return (T)(GutilNumber.isHexNumber(trimmed) ? GutilNumber.decodeBigInteger(trimmed) : new BigInteger(trimmed));
        }
        if (Float.class == targetClass) {
            return (T)Float.valueOf(trimmed);
        }
        if (Double.class == targetClass) {
            return (T)Double.valueOf(trimmed);
        }
        if (BigDecimal.class == targetClass || Number.class == targetClass) {
            return (T)new BigDecimal(trimmed);
        }
        throw new IllegalArgumentException("Cannot convert String [" + text + "] to target class [" + targetClass.getName() + "]");
    }

    public static <T extends Number> T parseNumber(String text, Class<T> targetClass, NumberFormat numberFormat) {
        if (numberFormat != null) {
            GutilAssert.notNull((Object)text, "Text must not be null");
            GutilAssert.notNull(targetClass, "Target class must not be null");
            DecimalFormat decimalFormat = null;
            boolean resetBigDecimal = false;
            if (numberFormat instanceof DecimalFormat) {
                decimalFormat = (DecimalFormat)numberFormat;
                if (BigDecimal.class == targetClass && !decimalFormat.isParseBigDecimal()) {
                    decimalFormat.setParseBigDecimal(true);
                    resetBigDecimal = true;
                }
            }
            try {
                Number number = numberFormat.parse(GutilStr.trimAllWhitespace(text));
                T t = GutilNumber.convertNumberToTargetClass(number, targetClass);
                return t;
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Could not parse number: " + ex.getMessage());
            }
            finally {
                if (resetBigDecimal) {
                    decimalFormat.setParseBigDecimal(false);
                }
            }
        }
        return GutilNumber.parseNumber(text, targetClass);
    }

    private static boolean isHexNumber(String value) {
        int index = value.startsWith("-") ? 1 : 0;
        return value.startsWith("0x", index) || value.startsWith("0X", index) || value.startsWith("#", index);
    }

    private static BigInteger decodeBigInteger(String value) {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (value.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (value.startsWith("0x", index) || value.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (value.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (value.startsWith("0", index) && value.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        BigInteger result = new BigInteger(value.substring(index), radix);
        return negative ? result.negate() : result;
    }

    public static double add(float v1, float v2) {
        return GutilNumber.add(Float.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double add(float v1, double v2) {
        return GutilNumber.add(Float.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double add(double v1, float v2) {
        return GutilNumber.add(Double.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double add(double v1, double v2) {
        return GutilNumber.add(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double add(Double v1, Double v2) {
        return GutilNumber.add((Number)v1, (Number)v2).doubleValue();
    }

    public static BigDecimal add(Number v1, Number v2) {
        return GutilNumber.add(new Number[]{v1, v2});
    }

    public static BigDecimal add(Number ... values) {
        if (GutilArray.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        BigDecimal result = null == value ? BigDecimal.ZERO : new BigDecimal(value.toString());
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.add(new BigDecimal(value.toString()));
        }
        return result;
    }

    public static BigDecimal add(String ... values) {
        if (GutilArray.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        String value = values[0];
        BigDecimal result = null == value ? BigDecimal.ZERO : new BigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.add(new BigDecimal(value));
        }
        return result;
    }

    public static BigDecimal add(BigDecimal ... values) {
        if (GutilArray.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal value = values[0];
        BigDecimal result = null == value ? BigDecimal.ZERO : value;
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.add(value);
        }
        return result;
    }

    public static double sub(float v1, float v2) {
        return GutilNumber.sub(Float.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double sub(float v1, double v2) {
        return GutilNumber.sub(Float.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double sub(double v1, float v2) {
        return GutilNumber.sub(Double.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double sub(double v1, double v2) {
        return GutilNumber.sub(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double sub(Double v1, Double v2) {
        return GutilNumber.sub((Number)v1, (Number)v2).doubleValue();
    }

    public static BigDecimal sub(Number v1, Number v2) {
        return GutilNumber.sub(new Number[]{v1, v2});
    }

    public static BigDecimal sub(Number ... values) {
        if (GutilArray.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        BigDecimal result = null == value ? BigDecimal.ZERO : new BigDecimal(value.toString());
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.subtract(new BigDecimal(value.toString()));
        }
        return result;
    }

    public static BigDecimal sub(String ... values) {
        if (GutilArray.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        String value = values[0];
        BigDecimal result = null == value ? BigDecimal.ZERO : new BigDecimal(value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.subtract(new BigDecimal(value));
        }
        return result;
    }

    public static BigDecimal sub(BigDecimal ... values) {
        if (GutilArray.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal value = values[0];
        BigDecimal result = null == value ? BigDecimal.ZERO : value;
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.subtract(value);
        }
        return result;
    }

    public static double mul(float v1, float v2) {
        return GutilNumber.mul(Float.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double mul(float v1, double v2) {
        return GutilNumber.mul(Float.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double mul(double v1, float v2) {
        return GutilNumber.mul(Double.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double mul(double v1, double v2) {
        return GutilNumber.mul(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double mul(Double v1, Double v2) {
        return GutilNumber.mul((Number)v1, (Number)v2).doubleValue();
    }

    public static BigDecimal mul(Number v1, Number v2) {
        return GutilNumber.mul(new Number[]{v1, v2});
    }

    public static BigDecimal mul(Number ... values) {
        if (GutilArray.isEmpty(values) || GutilArray.hasNull(values)) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        BigDecimal result = new BigDecimal(value.toString());
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            result = result.multiply(new BigDecimal(value.toString()));
        }
        return result;
    }

    public static BigDecimal mul(String v1, String v2) {
        return GutilNumber.mul((Number)new BigDecimal(v1), (Number)new BigDecimal(v2));
    }

    public static BigDecimal mul(String ... values) {
        if (GutilArray.isEmpty(values) || GutilArray.hasNull(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = new BigDecimal(values[0]);
        for (int i = 1; i < values.length; ++i) {
            result = result.multiply(new BigDecimal(values[i]));
        }
        return result;
    }

    public static BigDecimal mul(BigDecimal ... values) {
        if (GutilArray.isEmpty(values) || GutilArray.hasNull(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result = values[0];
        for (int i = 1; i < values.length; ++i) {
            result = result.multiply(values[i]);
        }
        return result;
    }

    public static double div(float v1, float v2) {
        return GutilNumber.div(v1, v2, 10);
    }

    public static double div(float v1, double v2) {
        return GutilNumber.div(v1, v2, 10);
    }

    public static double div(double v1, float v2) {
        return GutilNumber.div(v1, v2, 10);
    }

    public static double div(double v1, double v2) {
        return GutilNumber.div(v1, v2, 10);
    }

    public static double div(Double v1, Double v2) {
        return GutilNumber.div(v1, v2, 10);
    }

    public static BigDecimal div(Number v1, Number v2) {
        return GutilNumber.div(v1, v2, 10);
    }

    public static BigDecimal div(String v1, String v2) {
        return GutilNumber.div(v1, v2, 10);
    }

    public static double div(float v1, float v2, int scale) {
        return GutilNumber.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(float v1, double v2, int scale) {
        return GutilNumber.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(double v1, float v2, int scale) {
        return GutilNumber.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(double v1, double v2, int scale) {
        return GutilNumber.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(Double v1, Double v2, int scale) {
        return GutilNumber.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(Number v1, Number v2, int scale) {
        return GutilNumber.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(String v1, String v2, int scale) {
        return GutilNumber.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(float v1, float v2, int scale, RoundingMode roundingMode) {
        return GutilNumber.div(Float.toString(v1), Float.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(float v1, double v2, int scale, RoundingMode roundingMode) {
        return GutilNumber.div(Float.toString(v1), Double.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(double v1, float v2, int scale, RoundingMode roundingMode) {
        return GutilNumber.div(Double.toString(v1), Float.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(double v1, double v2, int scale, RoundingMode roundingMode) {
        return GutilNumber.div(Double.toString(v1), Double.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(Double v1, Double v2, int scale, RoundingMode roundingMode) {
        return GutilNumber.div((Number)v1, (Number)v2, scale, roundingMode).doubleValue();
    }

    public static BigDecimal div(Number v1, Number v2, int scale, RoundingMode roundingMode) {
        return GutilNumber.div(v1.toString(), v2.toString(), scale, roundingMode);
    }

    public static BigDecimal div(String v1, String v2, int scale, RoundingMode roundingMode) {
        return GutilNumber.div(new BigDecimal(v1), new BigDecimal(v2), scale, roundingMode);
    }

    public static BigDecimal div(BigDecimal v1, BigDecimal v2, int scale, RoundingMode roundingMode) {
        GutilAssert.notNull((Object)v2, "Divisor must be not null !");
        if (null == v1) {
            return BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = -scale;
        }
        return v1.divide(v2, scale, roundingMode);
    }

    public static int ceilDiv(int v1, int v2) {
        return (int)Math.ceil((double)v1 / (double)v2);
    }

    public static BigDecimal round(double v, int scale) {
        return GutilNumber.round(v, scale, RoundingMode.HALF_UP);
    }

    public static String roundStr(double v, int scale) {
        return GutilNumber.round(v, scale).toString();
    }

    public static BigDecimal round(String numberStr, int scale) {
        return GutilNumber.round(numberStr, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal round(BigDecimal number, int scale) {
        return GutilNumber.round(number, scale, RoundingMode.HALF_UP);
    }

    public static String roundStr(String numberStr, int scale) {
        return GutilNumber.round(numberStr, scale).toString();
    }

    public static BigDecimal round(double v, int scale, RoundingMode roundingMode) {
        return GutilNumber.round(Double.toString(v), scale, roundingMode);
    }

    public static String roundStr(double v, int scale, RoundingMode roundingMode) {
        return GutilNumber.round(v, scale, roundingMode).toString();
    }

    public static BigDecimal round(String numberStr, int scale, RoundingMode roundingMode) {
        GutilAssert.hasLength(numberStr, "numberStr is notEmpty");
        if (scale < 0) {
            scale = 0;
        }
        return GutilNumber.round(GutilNumber.toBigDecimal(numberStr), scale, roundingMode);
    }

    public static BigDecimal round(BigDecimal number, int scale, RoundingMode roundingMode) {
        if (null == number) {
            number = BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = 0;
        }
        if (null == roundingMode) {
            roundingMode = RoundingMode.HALF_UP;
        }
        return number.setScale(scale, roundingMode);
    }

    public static String roundStr(String numberStr, int scale, RoundingMode roundingMode) {
        return GutilNumber.round(numberStr, scale, roundingMode).toString();
    }

    public static BigDecimal roundHalfEven(Number number, int scale) {
        return GutilNumber.roundHalfEven(GutilNumber.toBigDecimal(number), scale);
    }

    public static BigDecimal roundHalfEven(BigDecimal value, int scale) {
        return GutilNumber.round(value, scale, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal roundDown(Number number, int scale) {
        return GutilNumber.roundDown(GutilNumber.toBigDecimal(number), scale);
    }

    public static BigDecimal roundDown(BigDecimal value, int scale) {
        return GutilNumber.round(value, scale, RoundingMode.DOWN);
    }

    public static String decimalFormat(String pattern, double value) {
        return new DecimalFormat(pattern).format(value);
    }

    public static String decimalFormat(String pattern, long value) {
        return new DecimalFormat(pattern).format(value);
    }

    public static String decimalFormat(String pattern, Object value) {
        return new DecimalFormat(pattern).format(value);
    }

    public static String decimalFormatMoney(double value) {
        return GutilNumber.decimalFormat(",##0.00", value);
    }

    public static String formatPercent(double number, int scale) {
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setMaximumFractionDigits(scale);
        return format.format(number);
    }

    public static boolean isNumber(CharSequence str) {
        int i;
        int start;
        if (GutilStr.isBlank(str)) {
            return false;
        }
        char[] chars = str.toString().toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' || chars[0] == '+' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && (chars[start + 1] == 'x' || chars[start + 1] == 'X')) {
            int i2 = start + 2;
            if (i2 == sz) {
                return false;
            }
            while (i2 < chars.length) {
                if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit && !hasExp;
            }
            return false;
        }
        return false == allowSigns && foundDigit;
    }

    public static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isLong(String s) {
        try {
            Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
            return s.contains(".");
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isPrimes(int n) {
        GutilAssert.isTrue(n > 1, "The number must be > 1");
        int i = 2;
        while ((double)i <= Math.sqrt(n)) {
            if (n % i == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int[] generateRandomNumber(int begin, int end, int size) {
        int[] seed = GutilArray.range(begin, end);
        return GutilNumber.generateRandomNumber(begin, end, size, seed);
    }

    public static int[] generateRandomNumber(int begin, int end, int size, int[] seed) {
        if (begin > end) {
            int temp = begin;
            begin = end;
            end = temp;
        }
        GutilAssert.isTrue(end - begin > size, "Size is larger than range between begin and end!");
        GutilAssert.isTrue(seed.length > size, "Size is larger than seed size!");
        int[] ranArr = new int[size];
        for (int i = 0; i < size; ++i) {
            int j = ThreadLocalRandom.current().nextInt(seed.length - i);
            ranArr[i] = seed[j];
            seed[j] = seed[seed.length - 1 - i];
        }
        return ranArr;
    }

    public static Integer[] generateBySet(int begin, int end, int size) {
        if (begin > end) {
            int temp = begin;
            begin = end;
            end = temp;
        }
        if (end - begin < size) {
            throw new IllegalStateException("Size is larger than range between begin and end!");
        }
        Random ran = new Random();
        HashSet<Integer> set = new HashSet<Integer>();
        while (set.size() < size) {
            set.add(begin + ran.nextInt(end - begin));
        }
        return set.toArray(new Integer[size]);
    }

    public static int[] range(int stop) {
        return GutilNumber.range(0, stop);
    }

    public static int[] range(int start, int stop) {
        return GutilNumber.range(start, stop, 1);
    }

    public static int[] range(int start, int stop, int step) {
        if (start < stop) {
            step = Math.abs(step);
        } else if (start > stop) {
            step = -Math.abs(step);
        } else {
            return new int[]{start};
        }
        int size = Math.abs((stop - start) / step) + 1;
        int[] values = new int[size];
        int index = 0;
        int i = start;
        while (step > 0 ? i <= stop : i >= stop) {
            values[index] = i;
            ++index;
            i += step;
        }
        return values;
    }

    public static Collection<Integer> appendRange(int start, int stop, Collection<Integer> values) {
        return GutilNumber.appendRange(start, stop, 1, values);
    }

    public static Collection<Integer> appendRange(int start, int stop, int step, Collection<Integer> values) {
        if (start < stop) {
            step = Math.abs(step);
        } else if (start > stop) {
            step = -Math.abs(step);
        } else {
            values.add(start);
            return values;
        }
        int i = start;
        while (step > 0 ? i <= stop : i >= stop) {
            values.add(i);
            i += step;
        }
        return values;
    }

    public static long factorial(long start, long end) {
        if (start < 0L || end < 0L) {
            throw new IllegalArgumentException(GutilStr.format((CharSequence)"Factorial start and end both must be >= 0, but got start={}, end={}", start, end));
        }
        if (0L == start || start == end) {
            return 1L;
        }
        if (start < end) {
            return 0L;
        }
        return GutilNumber.factorialMultiplyAndCheck(start, GutilNumber.factorial(start - 1L, end));
    }

    private static long factorialMultiplyAndCheck(long a, long b) {
        if (a <= Long.MAX_VALUE / b) {
            return a * b;
        }
        throw new IllegalArgumentException(GutilStr.format((CharSequence)"Overflow in multiplication: {} * {}", a, b));
    }

    public static long factorial(long n) {
        if (n < 0L || n > 20L) {
            throw new IllegalArgumentException(GutilStr.format((CharSequence)"Factorial must have n >= 0 and n <= 20 for n!, but got n = {}", n));
        }
        return FACTORIALS[(int)n];
    }

    public static long sqrt(long x) {
        long y = 0L;
        for (long b = 0x4000000000000000L; b > 0L; b >>= 2) {
            if (x >= y + b) {
                x -= y + b;
                y >>= 1;
                y += b;
                continue;
            }
            y >>= 1;
        }
        return y;
    }

    public static int processMultiple(int selectNum, int minNum) {
        int result = GutilNumber.mathSubnode(selectNum, minNum) / GutilNumber.mathNode(selectNum - minNum);
        return result;
    }

    public static int divisor(int m, int n) {
        while (m % n != 0) {
            int temp = m % n;
            m = n;
            n = temp;
        }
        return n;
    }

    public static int multiple(int m, int n) {
        return m * n / GutilNumber.divisor(m, n);
    }

    public static String getBinaryStr(Number number) {
        if (number instanceof Long) {
            return Long.toBinaryString((Long)number);
        }
        if (number instanceof Integer) {
            return Integer.toBinaryString((Integer)number);
        }
        return Long.toBinaryString(number.longValue());
    }

    public static int binaryToInt(String binaryStr) {
        return Integer.parseInt(binaryStr, 2);
    }

    public static long binaryToLong(String binaryStr) {
        return Long.parseLong(binaryStr, 2);
    }

    public static int compare(char x, char y) {
        return x - y;
    }

    public static int compare(double x, double y) {
        return Double.compare(x, y);
    }

    public static int compare(int x, int y) {
        return Integer.compare(x, y);
    }

    public static int compare(long x, long y) {
        return Long.compare(x, y);
    }

    public static int compare(short x, short y) {
        return Short.compare(x, y);
    }

    public static int compare(byte x, byte y) {
        return Byte.compare(x, y);
    }

    public static boolean isGreater(BigDecimal bigNum1, BigDecimal bigNum2) {
        GutilAssert.notNull((Object)bigNum1, "bigNum1 is not Null");
        GutilAssert.notNull((Object)bigNum2, "bigNum2 is not Null");
        return bigNum1.compareTo(bigNum2) > 0;
    }

    public static boolean isGreaterOrEqual(BigDecimal bigNum1, BigDecimal bigNum2) {
        GutilAssert.notNull((Object)bigNum1, "bigNum1 is not Null");
        GutilAssert.notNull((Object)bigNum2, "bigNum2 is not Null");
        return bigNum1.compareTo(bigNum2) >= 0;
    }

    public static boolean isLess(BigDecimal bigNum1, BigDecimal bigNum2) {
        GutilAssert.notNull((Object)bigNum1, "bigNum1 is not Null");
        GutilAssert.notNull((Object)bigNum2, "bigNum2 is not Null");
        return bigNum1.compareTo(bigNum2) < 0;
    }

    public static boolean isLessOrEqual(BigDecimal bigNum1, BigDecimal bigNum2) {
        GutilAssert.notNull((Object)bigNum1, "bigNum1 is not Null");
        GutilAssert.notNull((Object)bigNum2, "bigNum2 is not Null");
        return bigNum1.compareTo(bigNum2) <= 0;
    }

    public static boolean equals(double num1, double num2) {
        return Double.doubleToLongBits(num1) == Double.doubleToLongBits(num2);
    }

    public static boolean equals(float num1, float num2) {
        return Float.floatToIntBits(num1) == Float.floatToIntBits(num2);
    }

    public static boolean equals(BigDecimal bigNum1, BigDecimal bigNum2) {
        if (bigNum1 == bigNum2) {
            return true;
        }
        if (bigNum1 == null || bigNum2 == null) {
            return false;
        }
        return 0 == bigNum1.compareTo(bigNum2);
    }

    public static boolean equals(char c1, char c2, boolean ignoreCase) {
        return GutilChar.equals(c1, c2, ignoreCase);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray) {
        return (T)GutilArray.min(numberArray);
    }

    public static long min(long ... numberArray) {
        return GutilArray.min(numberArray);
    }

    public static int min(int ... numberArray) {
        return GutilArray.min(numberArray);
    }

    public static short min(short ... numberArray) {
        return GutilArray.min(numberArray);
    }

    public static double min(double ... numberArray) {
        return GutilArray.min(numberArray);
    }

    public static float min(float ... numberArray) {
        return GutilArray.min(numberArray);
    }

    public static BigDecimal min(BigDecimal ... numberArray) {
        return (BigDecimal)GutilArray.min((Comparable[])numberArray);
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray) {
        return (T)GutilArray.max(numberArray);
    }

    public static long max(long ... numberArray) {
        return GutilArray.max(numberArray);
    }

    public static int max(int ... numberArray) {
        return GutilArray.max(numberArray);
    }

    public static short max(short ... numberArray) {
        return GutilArray.max(numberArray);
    }

    public static double max(double ... numberArray) {
        return GutilArray.max(numberArray);
    }

    public static float max(float ... numberArray) {
        return GutilArray.max(numberArray);
    }

    public static BigDecimal max(BigDecimal ... numberArray) {
        return (BigDecimal)GutilArray.max((Comparable[])numberArray);
    }

    public static String toStr(Number number, String defaultValue) {
        return null == number ? defaultValue : GutilNumber.toStr(number);
    }

    public static String toStr(Number number) {
        GutilAssert.notNull((Object)number, "Number is null !");
        if (number instanceof BigDecimal) {
            return GutilNumber.toStr((BigDecimal)number);
        }
        GutilAssert.isTrue(GutilNumber.isValidNumber(number), "Number is non-finite!");
        String string = number.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static String toStr(BigDecimal bigDecimal) {
        GutilAssert.notNull((Object)bigDecimal, "BigDecimal is null !");
        return bigDecimal.stripTrailingZeros().toPlainString();
    }

    public static BigDecimal toBigDecimal(Number number) {
        if (null == number) {
            return BigDecimal.ZERO;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Long) {
            return new BigDecimal((Long)number);
        }
        if (number instanceof Integer) {
            return new BigDecimal((Integer)number);
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return GutilNumber.toBigDecimal(number.toString());
    }

    public static BigDecimal toBigDecimal(String number) {
        return GutilStr.isBlank(number) ? BigDecimal.ZERO : new BigDecimal(number);
    }

    public static BigInteger toBigInteger(Number number) {
        if (null == number) {
            return BigInteger.ZERO;
        }
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof Long) {
            return BigInteger.valueOf((Long)number);
        }
        return GutilNumber.toBigInteger(number.longValue());
    }

    public static BigInteger toBigInteger(String number) {
        return GutilStr.isBlank(number) ? BigInteger.ZERO : new BigInteger(number);
    }

    @Deprecated
    public static boolean isBlankChar(char c) {
        return GutilNumber.isBlankChar((int)c);
    }

    @Deprecated
    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234;
    }

    public static int count(int total, int part) {
        return total % part == 0 ? total / part : total / part + 1;
    }

    public static BigDecimal null2Zero(BigDecimal decimal) {
        return decimal == null ? BigDecimal.ZERO : decimal;
    }

    public static int zero2One(int value) {
        return 0 == value ? 1 : value;
    }

    public static BigInteger newBigInteger(String str) {
        if (null == (str = GutilStr.trimToNull(str))) {
            return null;
        }
        int pos = 0;
        int radix = 10;
        boolean negate = false;
        if (str.startsWith("-")) {
            negate = true;
            pos = 1;
        }
        if (str.startsWith("0x", pos) || str.startsWith("0X", pos)) {
            radix = 16;
            pos += 2;
        } else if (str.startsWith("#", pos)) {
            radix = 16;
            ++pos;
        } else if (str.startsWith("0", pos) && str.length() > pos + 1) {
            radix = 8;
            ++pos;
        }
        if (pos > 0) {
            str = str.substring(pos);
        }
        BigInteger value = new BigInteger(str, radix);
        return negate ? value.negate() : value;
    }

    public static boolean isBeside(long number1, long number2) {
        return Math.abs(number1 - number2) == 1L;
    }

    public static boolean isBeside(int number1, int number2) {
        return Math.abs(number1 - number2) == 1;
    }

    public static int partValue(int total, int partCount) {
        return GutilNumber.partValue(total, partCount, true);
    }

    public static int partValue(int total, int partCount, boolean isPlusOneWhenHasRem) {
        int partValue = total / partCount;
        if (isPlusOneWhenHasRem && total % partCount > 0) {
            ++partValue;
        }
        return partValue;
    }

    public static BigDecimal pow(Number number, int n) {
        return GutilNumber.pow(GutilNumber.toBigDecimal(number), n);
    }

    public static BigDecimal pow(BigDecimal number, int n) {
        return number.pow(n);
    }

    public static boolean isPowerOfTwo(long n) {
        return n > 0L && (n & n - 1L) == 0L;
    }

    public static int parseInt(String number) throws NumberFormatException {
        if (GutilStr.isBlank(number)) {
            return 0;
        }
        if (GutilStr.isEmpty(number = GutilStr.subBefore((CharSequence)number, '.', false))) {
            return 0;
        }
        if (GutilStr.startWithIgnoreCase(number, "0x")) {
            return Integer.parseInt(number.substring(2), 16);
        }
        return Integer.parseInt(GutilNumber.removeNumberFlag(number));
    }

    public static long parseLong(String number) {
        if (GutilStr.isBlank(number)) {
            return 0L;
        }
        if (GutilStr.isEmpty(number = GutilStr.subBefore((CharSequence)number, '.', false))) {
            return 0L;
        }
        if (number.startsWith("0x")) {
            return Long.parseLong(number.substring(2), 16);
        }
        return Long.parseLong(GutilNumber.removeNumberFlag(number));
    }

    public static Number parseNumber(String numberStr) {
        numberStr = GutilNumber.removeNumberFlag(numberStr);
        try {
            return NumberFormat.getInstance().parse(numberStr);
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] toBytes(int value) {
        byte[] result = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        return result;
    }

    public static int toInt(byte[] bytes) {
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static byte[] toUnsignedByteArray(BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0) {
            byte[] tmp = new byte[bytes.length - 1];
            System.arraycopy(bytes, 1, tmp, 0, tmp.length);
            return tmp;
        }
        return bytes;
    }

    public static byte[] toUnsignedByteArray(int length, BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (bytes.length == length) {
            return bytes;
        }
        int start = bytes[0] == 0 ? 1 : 0;
        int count = bytes.length - start;
        if (count > length) {
            throw new IllegalArgumentException("standard length exceeded for value");
        }
        byte[] tmp = new byte[length];
        System.arraycopy(bytes, start, tmp, tmp.length - count, count);
        return tmp;
    }

    public static BigInteger fromUnsignedByteArray(byte[] buf) {
        return new BigInteger(1, buf);
    }

    public static BigInteger fromUnsignedByteArray(byte[] buf, int off, int length) {
        byte[] mag = buf;
        if (off != 0 || length != buf.length) {
            mag = new byte[length];
            System.arraycopy(buf, off, mag, 0, length);
        }
        return new BigInteger(1, mag);
    }

    public static boolean isValidNumber(Number number) {
        if (number instanceof Double) {
            return false == ((Double)number).isInfinite() && false == ((Double)number).isNaN();
        }
        if (number instanceof Float) {
            return false == ((Float)number).isInfinite() && false == ((Float)number).isNaN();
        }
        return true;
    }

    private static int mathSubnode(int selectNum, int minNum) {
        if (selectNum == minNum) {
            return 1;
        }
        return selectNum * GutilNumber.mathSubnode(selectNum - 1, minNum);
    }

    private static int mathNode(int selectNum) {
        if (selectNum == 0) {
            return 1;
        }
        return selectNum * GutilNumber.mathNode(selectNum - 1);
    }

    private static String removeNumberFlag(String number) {
        int lastPos;
        char lastCharUpper;
        if (GutilStr.contains((CharSequence)number, ',')) {
            number = GutilStr.removeAll((CharSequence)number, ',');
        }
        if ('D' == (lastCharUpper = Character.toUpperCase(number.charAt(lastPos = number.length() - 1))) || 'L' == lastCharUpper || 'F' == lastCharUpper) {
            number = GutilStr.subPre(number, lastPos);
        }
        return number;
    }

    static {
        HashSet<Class> numberTypes = new HashSet<Class>(8);
        numberTypes.add(Byte.class);
        numberTypes.add(Short.class);
        numberTypes.add(Integer.class);
        numberTypes.add(Long.class);
        numberTypes.add(BigInteger.class);
        numberTypes.add(Float.class);
        numberTypes.add(Double.class);
        numberTypes.add(BigDecimal.class);
        STANDARD_NUMBER_TYPES = Collections.unmodifiableSet(numberTypes);
        FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    }
}

