package com.gw.web.active;

import com.gw.base.active.GiActivable;
import com.gw.base.active.GiActiver;
import com.gw.base.lang.invoke.GaMethodHandImpl;
import com.gw.base.lang.invoke.GaMethodHandImpl.ImplType;
import com.gw.base.lang.invoke.GkMethodHand;
import com.gw.web.util.GwHttpServletHelper;
import java.util.concurrent.ConcurrentHashMap;

public class GwWebActiver<U extends GiActivable> implements GiActiver<U> {



	static {
		GkMethodHand.implFromClass(GwWebActiver.class);
	}

	private static ConcurrentHashMap<Class<?>,GiActiver<?>> webActiveActivers = new ConcurrentHashMap<>();

	private String requestActiveKey = "gw-webactive";


	public GwWebActiver(Class<U> clientClass) {
		requestActiveKey = "gw-webactive-"+clientClass.getSimpleName();
		webActiveActivers.put(clientClass, this);
	}
	
	@GaMethodHandImpl(implClass=GiActiver.class,implMethod="getActiver",type=ImplType.cover)
	private static <U extends GiActivable> GiActiver<U> getActiver(Class<U> clientClass) {
		if(webActiveActivers.containsKey(clientClass)) {
			return (GiActiver<U>)webActiveActivers.get(clientClass);
		}
		return new GwWebActiver(clientClass);
	}
	

	@Override
	public U active() {
		Object client = GwHttpServletHelper.getRequest().getAttribute(requestActiveKey);
		return (U)client;
	}

	@Override
	public void active(U act) {
		GwHttpServletHelper.getRequest().setAttribute(requestActiveKey,act);
	}

	@Override
	public void deactive(U client) {
		GwHttpServletHelper.getRequest().removeAttribute(requestActiveKey);
	}



}
