package com.gw.web.data.page;

import javax.servlet.http.HttpServletRequest;
import com.gw.base.data.page.GiPageParam;
import com.gw.base.data.page.GiPageParamProvider;
import com.gw.base.data.page.support.GwPageParam;
import com.gw.base.env.property.GwPropertyHelper;
import com.gw.base.util.GutilStr;
import com.gw.web.util.GwHttpServletHelper;

/**
 * 分页参数默认提供者
 * @author Ray
 *
 */
public class GwWebPageParamProvider implements GiPageParamProvider  {

	public GwWebPageParamProvider() {}
	
	@Override
	public GiPageParam getPageParam() {
		HttpServletRequest req = GwHttpServletHelper.getRequest();
		
		String startKey = "start";//GwPropertyHelper.getPropertier().getProperty("gw.data.page.param.start","start");
		String pageKey = "page";//GwPropertyHelper.getPropertier().getProperty("gw.data.page.param.page","page");
		String limitKey = "limit";//GwPropertyHelper.getPropertier().getProperty("gw.data.page.param.limit","limit");
		
        String start = req.getParameter(startKey);
        String page = req.getParameter(pageKey);
        String limit = req.getParameter(limitKey);
        Integer pageSize = null;
        Integer pageNum = null;
        Long startRow = null;
        if(limit != null && GutilStr.isInteger(limit)) {
        	pageSize = Integer.valueOf(limit);
        }else {
        	pageSize = 25;//GwPropertyHelper.getPropertier().getProperty("gw.data.page.param.pageSize",Integer.class,25);
        }
        if(page != null && GutilStr.isInteger(page)) {
        	pageNum = Integer.valueOf(page);
        }else if(start != null && GutilStr.isInteger(start)) {
        	startRow = Long.valueOf(start);
        }
        
        GwPageParam pp = new GwPageParam();
        
        return pp.putParam(pageSize, pageNum, startRow);
	}


}
