package com.gw.web.data.result;

import com.gw.base.data.result.GiResult;


/**
 * 
 * @author Ray
 *
 * @param <T>
 */
public interface GiWebResult<T> extends GiResult<T>{

	/**
	 * 获取重定向Location
	 * @return
	 */
	public String location();

	/**
	 * 设置重定向Location
	 * @param location
	 * @return
	 */
	public GiWebResult<T> andLocation(String location);


	/**
	 * 设置跳转
	 * @param location 重定向地址
	 * @param <K>
	 * @return
	 */
	public static<K> GiWebResult<K> withLocation(String location){
		return GiWebResult.<K>getResult(null).andLocation(location);
	}

	/**
	 * 获取结果对象
	 * @param resultType
	 * @param <K>
	 * @return
	 */
	public static<K> GiWebResult<K> getResult(Class<K> resultType){
		return (GiWebResult<K>)GiResult.<K>getResult(resultType);
	}

}
