package com.gw.web.session;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import com.gw.base.Gw;
import com.gw.base.cache.GiTtlCache;
import com.gw.base.util.GutilStr;
import com.gw.web.util.GutilCookie;
import com.gw.web.util.GwHttpServletHelper;

public class GwSessionConfig implements Serializable{
	
	private static final long serialVersionUID = -6794764219858353804L;
	
	/*
	protected static ThreadLocal<HttpSession> sessionThreadLocal = new ThreadLocal<HttpSession>();
	
	public static void cleanSessionCache() {
		if(useThreadLocal) {
			sessionThreadLocal.remove();
		}
	}
	*/

	private Class<? extends HttpSession> sessionClass = HttpSession.class;
	
	private String cookieKey = "gw-user-session";
	
	private String tokenKey = "code";
	
	
	private boolean tokenInHeader = false;
	
	private long httpTimeout = 30 * 60;//http超时时间，秒
	
	private int cookieTimeout = 60 * 60 * 24;//单位秒
	
	private long tokenTimeout = 1000 * 60 * 60 * 24 * 7; // 单位毫秒

	private boolean useCache = false;
	
	private String catalog = "gw:session:sessions:";
	
	
	private String cacheName;
	
	
	public GiTtlCache getSessionCache() {
		return Gw.ttlCache;
	}
	
	public GwSessionConfig(Class<? extends HttpSession> sessionClass) {
		this.sessionClass = sessionClass;
		GwSessionAn an = sessionClass.getAnnotation(GwSessionAn.class);
		if(an != null && !GwSessionAn.NULL.equals(an.catalog())) {
			catalog = an.catalog();
			cacheName = an.cacheName();
		}
		
	}
	
	@Override
	public boolean equals(Object obj) {
		if(obj != null && obj instanceof GwSessionConfig) {
			GwSessionConfig cfg = (GwSessionConfig)obj;
			if(Objects.equals(cfg.sessionClass,this.sessionClass) && Objects.equals(cfg.cookieKey,this.cookieKey) && Objects.equals(cfg.tokenKey,this.tokenKey)) {
				return true;
			}
		}
		return false;//super.equals(obj);
	}
	
	
	public String getRequestSessionCode(boolean autoCreate) {
		String code = null;
		if(sessionClass == GwSpringSession.class || sessionClass == HttpSession.class) {
			HttpSession hs = GwHttpServletHelper.getRequest().getSession(false);
			if(hs != null) {
				code = hs.getId();
			}else if(autoCreate) {
				code = GwHttpServletHelper.getRequest().getSession().getId();
			}
		}else if(sessionClass == GwCookieSession.class) {
			Cookie cookie = GutilCookie.getCookie(cookieKey);
			if(cookie != null) {
				code = cookie.getValue();
			}else if(autoCreate){
				code = UUID.randomUUID().toString();
				GutilCookie.addCookie(cookieKey, code, cookieTimeout);
			}
		}else if(sessionClass == GwTokenSession.class) {
			if(!useCache) {
				Object oldToken = GwHttpServletHelper.getRequest().getAttribute("gw-tokenKey-random");
				if(oldToken != null) {
					return (String)oldToken;
				}
			}
			String token = null;
			if(tokenInHeader) {
				token = GwHttpServletHelper.getRequest().getHeader(tokenKey);
			}else{
				token = GwHttpServletHelper.getRequest().getParameter(tokenKey);
			}
			if(GutilStr.hasText(token)) {
				code = token;
			}else if(autoCreate) {
				code = UUID.randomUUID().toString();
				if(!useCache) {
					GwHttpServletHelper.getRequest().setAttribute("gw-tokenKey-random", code);
				}
			}
		}
		return code;
	}
	
	public String getCookieKey() {
		return cookieKey;
	}

	public GwSessionConfig setCookieKey(String cookieKey) {
		this.cookieKey = cookieKey;
		return this;
	}

	public String getTokenKey() {
		return tokenKey;
	}

	public GwSessionConfig setTokenKey(String tokenKey) {
		this.tokenKey = tokenKey;
		return this;
	}

	public long getHttpTimeout() {
		return httpTimeout;
	}

	public GwSessionConfig setHttpTimeout(long httpTimeout) {
		this.httpTimeout = httpTimeout;
		return this;
	}

	public int getCookieTimeout() {
		return cookieTimeout;
	}

	public GwSessionConfig setCookieTimeout(int cookieTimeout) {
		this.cookieTimeout = cookieTimeout;
		return this;
	}

	public long getTokenTimeout() {
		return tokenTimeout;
	}

	public GwSessionConfig setTokenTimeout(long tokenTimeout) {
		this.tokenTimeout = tokenTimeout;
		return this;
	}

	public Class<? extends HttpSession> getSessionClass() {
		return sessionClass;
	}

	public String getCatalog() {
		return catalog;
	}

	public boolean isUseCache() {
		return useCache;
	}

	public void setUseCache(boolean useCache) {
		this.useCache = useCache;
	}

	public boolean isTokenInHeader() {
		return tokenInHeader;
	}

	public GwSessionConfig setTokenInHeader(boolean tokenInHeader) {
		this.tokenInHeader = tokenInHeader;
		return this;
	}
}
