package com.gw.web.user;

import java.io.Serializable;
import javax.servlet.http.HttpSession;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.session.GiSession;
import com.gw.base.user.session.GiSessionUser;
import com.gw.web.session.GwWebUserSession;
import com.gw.web.util.GwHttpServletHelper;

public interface GiWebUser<ID extends Serializable> extends GiSessionUser<ID> {
	
	
	public static GiLoger logger = GwLoger.getLoger(GiWebUser.class);
	
	
	
	
	default GiSession userSession(boolean autoCreate) {
		
		
		HttpSession httpSession = GwHttpServletHelper.getRequest().getSession(autoCreate);
		if(httpSession != null) {
			return new GwWebUserSession(httpSession);
		}
		return null;
	}
	
    /**
     * 设定用户为登录状态
     * @return 返回会话id
     */
	@Override
	default public void sessionLogin() {
		GiSessionUser.super.sessionLogin();
		
	}
	
	/**
     * 设定用户为登出状态
     * @return 
     */
	@Override
	default public void sessionLogout() {
		//GwUserActiver.getUserActiver().deactive(this);
		GiSessionUser.super.sessionLogout();
	}

}
