﻿(function() {
    if (window.GwBridge) {
        return;
    }
    var messageQueue = {};
	var uniqueId = 1;
	var toString = Object.prototype.toString;
	
	
	var defaultDelegage = {
		alert:function(sendMessage){
			var msg = sendMessage.param.msg;
			window.alert(msg);
			GwBridge.callbackHandler(sendMessage,null);
		},
		hasHandler:function(sendMessage){
			var handler = sendMessage.param.handler;
			
			var has = false;
			if(this[handler]){
				has = true;
			};
			GwBridge.callbackHandler(sendMessge,has);
		}
	};
	
	function _isIframeSupport(){
		return !(window.parent == window);
	}
	
	function _isAndroidSupport(){
		return !!(window.AndroidCallbackCommon && window.AndroidCallbackCommon.GwBridgeHandler);
	}
	
	function _isIOSSupport(){
		return !!(window.webkit && window.webkit.messageHandlers && window.webkit.messageHandlers.GwBridgeHandler);
	}

	function _callbackHandler(handMsg,res){
		if(GwBridge.isString(handMsg)){
			handMsg = JSON.parse(handMsg);
			res = handMsg.response;
			delete handMsg.response;
		}
		if(handMsg.taskId){
			var task = messageQueue[handMsg.taskId];
			if(task){
				if(task.callback){
					var scp = task.scope || window;
					var cb = GwBridge.isFunction(task.callback)?task.callback:scp[task.callback];
					cb.call(scp.scope,res,handMsg);
				}
				delete messageQueue[handMsg.taskId];
			}else{
				GwBridge.log("没有找到回调对应的任务,taskId:"+handMsg.taskId);
			}
		}else{
			GwBridge.log("回调缺少taskId:"+handMsg);
		}
	}

	function _invokeHandler(handler,param,callback,scope){
		var taskId = 'rx_bridge_' + (uniqueId++);
		var sendMessage = {
			taskId:taskId,
			handler:handler,
			param:param,
			source:GwBridge.name
		};
		messageQueue[taskId] = {
			callback:callback,
			scope:scope,
			request:sendMessage
		};
		if(_isIframeSupport()){
			window.parent.postMessage(JSON.stringify(sendMessage),"*");
		}else if(_isAndroidSupport()){
			var res = window.AndroidCallbackCommon.GwBridgeHandler(JSON.stringify(sendMessage));
			if(res && res.length > 0){
				GwBridge.callbackHandler(res);
			}
		}else if(_isIOSSupport()){
			window.webkit.messageHandlers.GwBridgeHandler.postMessage(JSON.stringify(sendMessage));
		}else{
			if(defaultDelegage[handler]){
				defaultDelegage[handler].call(window,sendMessage);
			}else{
				GwBridge.log("没有实现方法:" + handler);
			}
		}
		return taskId;
	}
	
	function _hasHandler(handler,callback){
		GwBridge.invokeHandler('hasHandler',{
		  handler:handler,
		},callback);
	}
	
	
    window.GwBridge = {
		name:new Date().getTime(),
		hasHandler:_hasHandler,
		registerHandler:function(handler,fn){
			defaultDelegage[handler] = fn;
		},
		log:function(msg){
			var div = document.createElement('div');
			  div.innerHTML = '<div style="display:block;padding:1em;border:1px solid #333;width:50%;margin:0 auto;z-index:30000;"><h4>这是调试消息'+
			  '</h4><div style="word-wrap:break-word;word-break:break-all;">'+msg+'</div><div style="margin:0 auto;width:max-content;padding:1em;">'+
				'<input type="button" onclick="this.parentNode.parentNode.parentNode.removeChild(this.parentNode.parentNode)" value="确定"></input></div></div>';
			  document.body.appendChild(div);
		},
		alert:function(msg,title,callback,scope){
			GwBridge.invokeHandler('alert',{
			  title:title,
			  msg:msg
			},callback,scope);
		},
        invokeHandler: _invokeHandler,
		callbackHandler : _callbackHandler,
		isIframeSupport:_isIframeSupport,
		isAndroidSupport:_isAndroidSupport,
		isIOSSupport:_isIOSSupport,
		isFunction:
        (typeof document !== 'undefined' && typeof document.getElementsByTagName('body') === 'function') ? function(value) {
            return !!value && toString.call(value) === '[object Function]';
        } : function(value) {
            return !!value && typeof value === 'function';
        },
		isArray:function(value){
			return toString.call(value) === '[object Array]';
		},
		isObject: (toString.call(null) === '[object Object]') ?
        function(value) {
            return value !== null && value !== undefined && toString.call(value) === '[object Object]' && value.ownerDocument === undefined;
        } :
        function(value) {
            return toString.call(value) === '[object Object]';
        },
		isString: function(value) {
            return typeof value === 'string';
        },
		getQueryString: function(key){
			if(URLSearchParams) {
				return new URLSearchParams(window.location.search).get(key);
			}else{
				var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
				var r = window.location.search.substr(1).match(reg);
				var context = "";
				if (r != null)
					context = decodeURIComponent(r[2]);
				reg = null;
				r = null;
				return context == null || context == "" || context == "undefined" ? "" : context;
			}
		},
		ajax: function (param){
			//发送异步请求
			//1.创建核心对象

			var param = param || {};

			var xmlhttp = null,url = param.url,method = param.method,headers = param.headers;
			if (window.XMLHttpRequest)
			{// code for IE7+, Firefox, Chrome, Opera, Safari
				xmlhttp=new XMLHttpRequest();
			}else{// code for IE6, IE5
				xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
			}


			//2. 建立连接
			/*
				参数：
					1. 请求方式：GET、POST
						* get方式，请求参数在URL后边拼接。send方法为空参
						* post方式，请求参数在send方法中定义
					2. 请求的URL：
					3. 同步或异步请求：true（异步）或 false（同步）

			 */
			xmlhttp.open(method,url,true);

			if(headers) {
				for(var o in headers) {
					xmlhttp.setRequestHeader(o, headers[o]);
				}
			}

			//3.发送请求
			xmlhttp.send();
			//4.接受并处理来自服务器的响应结果
			//获取方式 ：xmlhttp.responseText
			//当xmlhttp对象的就绪状态改变时，触发事件onreadystatechange。
			xmlhttp.onreadystatechange=function()
			{
				//判断readyState就绪状态是否为4，判断status响应状态码是否为200
				if (xmlhttp.readyState==4)
				{
					//获取服务器的响应结果
					var responseText = xmlhttp.responseText;
					var scp = param.scope || window;
					if(xmlhttp.status == 200){
						if(GwBridge.isFunction(param.success)){
							param.success.call(scp,responseText);
						}
					}else{
						if(GwBridge.isFunction(param.error)){
							param.error.call(scp,responseText);
						}
					}
				}
			}

		}
    };

	window.addEventListener("message",function(emsg){//e.source:发送消息的窗体 e.data:数据 e.origin:域名
		var msg = null;
		try{
			msg = JSON.parse(emsg.data);
		}catch(e){}
		if(msg && msg.taskId && msg.handler){
			if(msg.source == GwBridge.name){
				GwBridge.callbackHandler({
					taskId:msg.taskId,
					handler:msg.handler,
					supporter:msg.supporter
					//response:msg.response
				},msg.response);
			}else{
				GwBridge.invokeHandler(msg.handler,msg.param,function(res,opt){
					msg.response = res;
					emsg.source.postMessage(JSON.stringify(msg),"*");
				},window);
			}
		}
	},false);
	
})();