package com.gw.orm.mybatisplus.impls;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;

//import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.gw.base.gpa.dao.GiDeleteDao;
import com.gw.base.gpa.entity.GiEntityRemovable;


public interface PlusDeleteMapper<T extends GiEntityRemovable<PK>,PK extends Serializable> extends GiDeleteDao<T,PK>,BaseMapper<T>{

	/**
     * 根据条件删除记录
     *
     * @param t
     * @return
     */
	@Override
    default int gwDeleteBy(T t) {
    	return this.delete(new QueryWrapper<T>(t));
    }

    /**
     * 根据主键删除记录
     *
     * @param key
     * @return
     */
	@Override
    default void gwDeleteByPK(PK pk) {
		this.deleteById(pk);
	}

    /**
     * 根据主键批量删除
     *
     * @param key
     * @return
     */
	@Override
    default void gwDeleteByPK(List<PK> pks) {
		this.deleteBatchIds(pks);
	}
    
    /**
     * 删除所有数据
     *
     * @param key
     * @return
     */
	@Override
    default void gwDeleteAll() {
		this.delete(null);
	}
	
	
}
