package com.gw.orm.mybatisplus.impls;


import java.io.Serializable;
import java.util.List;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.gw.base.gpa.dao.GiCreateDao;
import com.gw.base.gpa.entity.GiEntitySaveable;


public interface PlusInsertMapper<T extends GiEntitySaveable<PK>,PK extends Serializable> extends GiCreateDao<T,PK>,BaseMapper<T>{
	
	/**
     * 保存一条记录(属性不判空，为空的属性插入为空，无视数据库默认值)
     * 
     * @param t
     * @return 
     */
	@Override
    default PK gwAccess(T t) {
    	this.insert(t);
    	return t.id();
    }
    
	/**
     * 批量插入(属性不判空，为空的属性插入为空，无视数据库默认值)
     * @param records
     * @return
     */
    @Override
    default List<PK> gwAccess(List<T> records) {
    	throw new RuntimeException("方法尚未实现");
    }
    
    
    /**
     * 插入一条记录(属性判空，为空的属性不做插入操作)
     * @param t
     * @return
     */
    @Override
    default PK gwAccessSelective(T t) {
    	throw new RuntimeException("方法尚未实现");
    }
    

    
    /**
     * 批量插入(属性判空，为空的属性不做插入操作)
     * @param records
     * @return
     */
    @Override
    default List<PK> gwAccessSelective(List<T> records) {
    	throw new RuntimeException("方法尚未实现");
    }
    

    
	
}
