package com.gw.orm.mybatisplus.impls;


import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.gw.base.gpa.dao.GiRetrieveDao;
import com.gw.base.gpa.entity.GiEntityQueryable;


public interface PlusRetrieveMapper<T extends GiEntityQueryable<PK>,PK extends Serializable> extends BaseMapper<T>,GiRetrieveDao<T,PK>{
	
	/**
     * 是否能够找到主键的记录
     * @param pk 
     * @return
     */
	default boolean selectExists(PK pk) {
		return this.selectById(pk) == null;
	}
	
    /**
     * 根据主键查询记录
     * @param pk 
     * @return
     */
	default T selectByPK(PK pk) {
		return this.selectById(pk);
	}
	/**
	 * 根据多个主键查询多个结果
	 * @param pks
	 * @return
	 */
	default Iterable<T> selectByPK(Iterable<PK> pks){
		
		Collection<PK> coll = new LinkedList<PK>();
		pks.forEach(coll::add);
		
		return this.selectBatchIds(coll);
	}
	
    /**
     * 根据实体中的属性进行查询，只能有一个返回值，有多个结果时抛出异常，查询条件使用等号
     * @param t
     * @return
     */
    default T selectOne(T t) {
    	return this.selectOne(new QueryWrapper<T>(t));
    }
    /**
     * 根据实体中的属性进行查询，只返回第一条数据,查询条件使用等号
     * @param t
     * @return
     */
    default T selectFirst(T t) {
    	Iterable<T> it = this.select(t);
    	if(it.iterator().hasNext()) {
    		return it.iterator().next();
    	}
    	return null;
    }
    
    /**
     * 查询单表所有记录
     * @return
     */
    default Iterable<T> selectAll(){
    	return this.selectList(null);
    }
    /**
     * 根据条件查询多条记录
     * @param t
     * @return
     */
    default Iterable<T> select(T t){
    	return this.selectList(new QueryWrapper<T>(t));
    }
    /**
     * 根据条件查询总数
     * @param t
     * @return
     */
    default long selectCount() {
    	Long ct = this.selectCount(null);
    	if(ct != null) {
    		return ct.longValue();
    	}
    	return 0;
    }
    
    
    
    
    /**
     * 是否能够找到主键的记录
     * @param pk 
     * @return
     */
    @Override
	default boolean gwExistsWithPK(PK pk) {
    	throw new RuntimeException("接口未实现");
    }
    /**
     * 根据主键查询记录
     * @param pk 
     * @return
     */
    @Override
	default T gwSearchByPK(PK pk) {
    	throw new RuntimeException("接口未实现");
    }
	/**
	 * 根据多个主键查询多个结果
	 * @param pks
	 * @return
	 */
    @Override
	default List<T> gwSearchByPK(Set<PK> pks) {
    	throw new RuntimeException("接口未实现");
    }
	
    /**
     * 根据实体中的属性进行查询，只能有一个返回值，有多个结果时抛出异常，查询条件使用等号
     * @param t
     * @return
     */
    @Override
	default T gwSearchOne(T t) {
    	throw new RuntimeException("接口未实现");
    }
    /**
     * 根据实体中的属性进行查询，只返回第一条数据,查询条件使用等号
     * @param t
     * @return
     */
    @Override
	default T gwSearchFirst(T t) {
    	throw new RuntimeException("接口未实现");
    }
    
    /**
     * 查询单表所有记录
     * @return
     */
    @Override
	default List<T> gwSearchAll() {
    	throw new RuntimeException("接口未实现");
    }
    /**
     * 根据条件查询多条记录
     * @param t
     * @return
     */
    @Override
	default List<T> gwSearch(T t) {
    	throw new RuntimeException("接口未实现");
    }
    /**
     * 根据条件查询总数
     * @param t
     * @return
     */
    @Override
	default long gwSearchCount(T t) {
    	throw new RuntimeException("接口未实现");
    }
    
}
