package com.gw.orm.tkmapper.impls;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.gw.base.exception.GwException;
import com.gw.base.gpa.dao.GiDeleteDao;
import com.gw.base.gpa.entity.GiEntityRemovable;
import com.gw.orm.mybatis.impls.MyBatisMapper;
import tk.mybatis.mapper.common.base.BaseDeleteMapper;
import tk.mybatis.mapper.common.example.DeleteByExampleMapper;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.mapperhelper.EntityHelper;


public interface TkDeleteMapper<T extends GiEntityRemovable<PK>,PK extends Serializable> extends MyBatisMapper<T,PK>,GiDeleteDao<T,PK>,BaseDeleteMapper<T>,DeleteByExampleMapper<T>/*,DeleteByIdsMapper<T>*/{
	

	
	/**
     * 根据实体属性作为条件进行删除，查询条件使用等号
     *
     * @param t
     * @return
     */
	@Override
    default int gwDeleteBy(T t) {
		return this.delete(t);
	}

    /**
     * 根据主键删除记录
     *
     * @param key
     * @return
     */
	@Override
    default void gwDeleteByPK(PK pk) {
		this.deleteByPrimaryKey(pk);
	}

    /**
     * 根据主键批量删除
     *
     * @param key
     * @return
     */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
    default void gwDeleteByPK(List<PK> pks) {
		
		Set<EntityColumn> cs = EntityHelper.getPKColumns(this.getModelClass());
		if(cs.size() == 1) {
			if(this instanceof tk.mybatis.mapper.additional.idlist.DeleteByIdListMapper) {
				 /**
			     * 根据主键字符串进行删除，类中只有存在一个带有@Id注解的字段
			     */
				((tk.mybatis.mapper.additional.idlist.DeleteByIdListMapper)this).deleteByIdList(pks);
			}else {
				throw new GwException("根据主键批量删除如果只有一个带有@Id注解的字段，{} 需要实现tk.mybatis.mapper.additional.idlist.DeleteByIdListMapper接口",this.getClass().getName());
			}
		}else {
			Set<PK> ids = new HashSet<>(pks);
			for(PK pk:ids) {
				this.deleteByPrimaryKey(pk);
			}
		}
	}
    
    /**
     * 删除所有数据
     *
     * @param key
     * @return
     */
	@Override
    default void gwDeleteAll() {
		Example ex = new Example(this.getModelClass());
		//ex.and(ex.createCriteria().andCondition("1=1"));
		this.deleteByExample(ex);
	}
	
}
