package com.gw.orm.tkmapper.impls;

import java.io.Serializable;
import java.util.List;

import com.gw.base.data.page.GfunPageExcute;
import com.gw.base.data.page.GiPageExcuter;
import com.gw.base.data.page.GiPageParam;
import com.gw.base.data.page.GiPager;
import com.gw.base.gpa.dao.GiPagerDao;
import com.gw.base.gpa.dao.GiRetrieveDao;
import com.gw.base.gpa.entity.GiEntityQueryable;
import com.gw.orm.tkmapper.page.TkGithubPageHelper;

/**
 * 分页查询
 *
 * @author Ray
 */
public interface TkPagerMapper<M extends GiEntityQueryable<PK>, PK extends Serializable> extends GiPagerDao<M, PK> {

	
	/*
    public static <P, R> GwPager<R> excute(GwParamPageExcute<P, R> excute, P param) {
        return TkPagerMapper.excute(excute, param, null);
    }

    public static <P, R> GwPager<R> excute(GwParamPageExcute<P, R> excute, P param, GwPageParam pageParam) {
        GwPageExcute<R> exec = new GwPageExcute<R>() {
            @Override
            public List<R> excute() {
                return excute.excute(param);
            }
        };
        return GwPageHelper.excute(exec, pageParam);
    }
    */


    /**
     * 获得分页处理者
     *
     * @return
     */
    default GiPageExcuter pageExcuter() {
        return TkGithubPageHelper.getPageExcuter();
    }

    /*
    default GwPagerProvider getPagerProvider() {
        return GwBeanHelper.getBean(GwPagerProvider.class);
    }

    default GwPager<M> getGwPager(Class<M> modelCls) {
        if (modelCls == null) {
            modelCls = this.getModelClass();
        }
        return GwPageHelper.getPager(modelCls);
    }

    default GwPageParamProvider getPageParamProvider() {
        return GwBeanHelper.getBean(GwPageParamProvider.class);
    }

    default GwPageParam getPageParam() {
        return this.getPageParamProvider().getPageParam();
    }
    */

    /**
     * 根据主键数组分页查询记录
     * @return default GwPager<M> selectByPKsPage(Object[] keys){
    Class<M> modelClass = this.getModelClass();
    GwSelectDao<M,PK> selectDao = GwSelectDao.<M,PK>getDao(modelClass);
    GwPager<M> pager = this.getGwPager(modelClass);
    GwPageExcute<M> exec = new GwPageExcute<M>() {
    @Override public GwPager<M> getGwPager(){
    return pager;
    }
    @Override public List<M> excute() {
    return selectDao.selectByPKs(keys);
    }};

    return getPageExcuter().excutePage(exec,getPageParam());
    }*/
    /**
     * 分页查询单表所有记录
     *
     * @return
     */
    @Override
    default GiPager<M> gwSearchPageAll(GiPageParam pageParam) {
        Class<M> modelClass = this.getModelClass();
        GiRetrieveDao<M, PK> selectDao = GiRetrieveDao.<M, PK>getDao(modelClass);
        GfunPageExcute<M> exec = new GfunPageExcute<M>() {
            @Override
            public Iterable<M> excute() {
                return selectDao.gwSearchAll();
            }
        };

        return pageExcuter().excutePage(exec, pageParam);
    }

    /**
     * 根据PO条件分页查询多条记录
     *
     * @param t
     * @return
     */
    @Override
    default GiPager<M> gwSearchPage(M t,GiPageParam pageParam) {
        Class<M> modelClass = this.getModelClass();
        GiRetrieveDao<M, PK> selectDao = GiRetrieveDao.<M, PK>getDao(modelClass);
        GfunPageExcute<M> exec = new GfunPageExcute<M>() {
            /**
			 * 
			 */
			private static final long serialVersionUID = 5789221554389121763L;

			@Override
            public Iterable<M> excute() {
                return selectDao.gwSearch(t);
            }
        };
        return pageExcuter().excutePage(exec,pageParam);
    }

    /**
     * 根据PO条件分页查询多条记录
     *
     * @param t
     * @return
     */
    @Override
    default GiPager<M> gwSearchPageByPK(List<PK> pks,GiPageParam pageParam) {
        Class<M> modelClass = this.getModelClass();
        GiRetrieveDao<M, PK> selectDao = GiRetrieveDao.<M, PK>getDao(modelClass);
        GfunPageExcute<M> exec = new GfunPageExcute<M>() {
            /**
			 * 
			 */
			private static final long serialVersionUID = 5789221554389121763L;

			@Override
            public Iterable<M> excute() {
                return selectDao.gwSearchByPK(pks);
            }
        };
        return pageExcuter().excutePage(exec,pageParam);
    }
    
    
}