package com.gw.orm.tkmapper.impls;

import java.io.Serializable;
import java.util.List;
import com.gw.base.gpa.dao.GiUpdateDao;
import com.gw.base.gpa.entity.GiEntityAlterable;
import com.gw.orm.mybatis.impls.MyBatisMapper;
import com.gw.orm.tkmapper.support.UpdateBatchMapper;

import tk.mybatis.mapper.common.base.BaseUpdateMapper;
import tk.mybatis.mapper.common.example.UpdateByExampleMapper;
import tk.mybatis.mapper.common.example.UpdateByExampleSelectiveMapper;

public interface TkUpdateMapper<T extends GiEntityAlterable<PK>, PK extends Serializable> extends MyBatisMapper<T, PK>, UpdateBatchMapper<T>, UpdateByExampleMapper<T>,
        UpdateByExampleSelectiveMapper<T>, BaseUpdateMapper<T>, GiUpdateDao<T, PK> {
    
    /**
     * 根据主键更新记录(更新所有字段)
     * @param t
     * @return
     */
    @Override
    default void gwUpdateByPK(T t) {
    	this.updateByPrimaryKey(t);
    }

    /**
     * 根据主键更新记录(更新不为Null的字段)
     * @param t
     * @return
     */
    @Override
    default void gwUpdateByPKSelective(T t) {
    	this.updateByPrimaryKeySelective(t);
    }

    /**
     * 根据主键批量更新
     * @param records
     * @return
     */
    @Override
    default void gwUpdateByPK(List<T> records) {
    	this.batchUpdateByPK(records);
    }
    
    /**
     * 根据主键批量更新(更新不为Null的字段)
     * @param records
     * @return
     */
    @Override
    default void gwUpdateByPKSelective(List<T> records) {
    	this.batchUpdateByPKSelective(records);
    }

}
