package com.gw.orm.tkmapper.page;

import java.util.Iterator;
import java.util.List;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.gw.base.data.page.GfunPageExcute;
import com.gw.base.data.page.GiPageExcuter;
import com.gw.base.data.page.GiPageParam;
import com.gw.base.data.page.GiPager;
import com.gw.base.gpa.support.GwOrder;
import com.gw.base.gpa.support.GwSort;
import com.gw.base.lang.lambda.GkfLambdaMeta;
import com.gw.base.util.GutilLambda;
import com.gw.orm.tkmapper.util.TkEntityHelper;

import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.EntityTable;
import tk.mybatis.mapper.mapperhelper.EntityHelper;

/**
 * TkMapper + GitHubPager的组合工具
 * @author Ray
 *
 */

public class TkGithubPageHelper implements GiPageExcuter{
	
	private static TkGithubPageHelper instance = new TkGithubPageHelper();
	
	
	/**
	 * 获取分页执行器
	 * @return
	 */
	public static GiPageExcuter getPageExcuter() {
		return instance;
	}
	
	
	private TkGithubPageHelper() {
		super();
	}
	
	
	/**
	 * 从GwSort对象拼装 排序语句
	 * @param sort
	 * @return
	 */
	
	public static String orderBySqlFromGwSort(GwSort sort) {
		
		if(sort != null) {
        	
        	Iterator<GwOrder<?>> iterator = sort.iterator();
        	
        	StringBuilder orderBy = new StringBuilder();
        	while(iterator.hasNext()) {
        		
        		GwOrder<?> order = iterator.next();
                
        		if(order.getPropertyFun() != null) {
        			
        			GkfLambdaMeta lm = GutilLambda.extract(order.getPropertyFun());
        			
        			String methName = lm.getImplMethodName().toUpperCase();
        			
        			EntityColumn ec = TkEntityHelper.getEntityColumnByMethodName(order.getEntityClass(), methName);
        			
        			if(ec != null) {
                        if (orderBy.length() != 0) {
                            orderBy.append(",");
                        }
                        orderBy.append(ec.getColumn()).append(" ").append(order.getDirection().value());
        			}
        		}else if(order.getProperty() != null) {
        			
        			EntityTable table = EntityHelper.getEntityTable(order.getEntityClass());
        			
        			loop2:for (EntityColumn column : table.getEntityClassColumns()) {
                    	
        				if(order.getProperty().equalsIgnoreCase(column.getProperty())) {
                            if (orderBy.length() != 0) {
                                orderBy.append(",");
                            }
                            orderBy.append(column.getColumn()).append(" ").append(order.getDirection().value());
                            break loop2;
        				}
                    }
        		}
        	}
        	
        	if(orderBy.length() > 0) {
        		return orderBy.toString();
        	}
        }
		
		return null;
	}
	
	
	@Override
	public <F> GiPager<F> excutePage(GfunPageExcute<F> pageExcute,GiPageParam pageParam) {
		
		//PageHelper.orderBy(TkGithubPageHelper.orderBySqlFromGwSort(pageParam.sort()));
        Page<F> page = PageHelper.startPage(pageParam.pageNum(), pageParam.pageSize(), TkGithubPageHelper.orderBySqlFromGwSort(pageParam.sort()));
        //page.setOrderBy(TkGithubPageHelper.orderBySqlFromGwSort(pageParam.sort()));
        
        Iterable<F> list = pageExcute.excute();
        PageInfo<F> pageInfo = new PageInfo<F>((List<F>)list);
        GiPager<F> pager = pageExcute.getGwPager();
        pageParam.putParam(pageInfo.getPageSize(), pageInfo.getPageNum(), pageInfo.getStartRow());
        pager.put(pageInfo.getList(),pageInfo.getTotal(),pageParam);
        return pager;
        /*
        pager.setList(list);//
        
        pager.setPageNum(pageInfo.getPageNum());//
        pager.setPageSize(pageInfo.getPageSize());//
        pager.setSize(pageInfo.getSize());
        pager.setStartRow(pageInfo.getStartRow());
        pager.setEndRow(pageInfo.getEndRow());
        
        pager.setPages(pageInfo.getPages());//
        pager.setPrePage(pageInfo.getPrePage());
        pager.setNextPage(pageInfo.getNextPage());
        pager.setIsFirstPage(pageInfo.isIsFirstPage());
        pager.setIsLastPage(pageInfo.isIsLastPage());
        pager.setHasPreviousPage(pageInfo.isHasPreviousPage());
        pager.setHasNextPage(pageInfo.isHasNextPage());
        pager.setNavigatePages(pageInfo.getNavigatePages());
        pager.setNavigatepageNums(pageInfo.getNavigatepageNums());
        pager.setNavigateFirstPage(pageInfo.getNavigateFirstPage());
        pager.setNavigateLastPage(pageInfo.getNavigateLastPage());
        pager.setTotal(pageInfo.getTotal());//
        return pager;
        */
	}
	
	
}
