/*
 * Decompiled with CFR 0.152.
 */
package com.gw.orm.tkmapper.util;

import com.gw.base.Gw;
import com.gw.base.tool.GkConcurrentReferenceHashMap;
import com.gw.base.util.GutilReflection;
import java.lang.reflect.Field;
import java.util.Map;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.EntityField;
import tk.mybatis.mapper.entity.EntityTable;
import tk.mybatis.mapper.mapperhelper.EntityHelper;

public class TkEntityHelper {
    private static final Map<String, EntityColumn> entityTableMap = new GkConcurrentReferenceHashMap();

    public static EntityColumn getEntityColumnByMethodName(Class<?> entityClass, String methodName) {
        return entityTableMap.computeIfAbsent(methodName, key -> {
            EntityTable table = EntityHelper.getEntityTable((Class)entityClass);
            for (EntityColumn column : table.getEntityClassColumns()) {
                EntityField ef = column.getEntityField();
                try {
                    Field getter = ef.getClass().getDeclaredField("getter");
                    GutilReflection.makeAccessible((Field)getter);
                    if (key.equalsIgnoreCase(getter.getName())) {
                        return column;
                    }
                    Field setter = ef.getClass().getDeclaredField("setter");
                    GutilReflection.makeAccessible((Field)setter);
                    if (!key.equalsIgnoreCase(setter.getName())) continue;
                    return column;
                }
                catch (NoSuchFieldException | SecurityException e) {
                    Gw.log.error((Throwable)e, "tk.mybatis.mapper.entity.EntityField\u7c7b\u65e0\u6cd5\u8bbf\u95ee getter setter\u5c5e\u6027", new Object[0]);
                }
            }
            return null;
        });
    }
}

