package com.gw.orm.springjpa.support;

import java.util.Iterator;
import java.util.function.Function;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Sort.Direction;
import com.gw.base.data.page.GiPageParam;
import com.gw.base.gpa.support.GwOrder;
import com.gw.base.gpa.support.GwSort;

/**
 * @author ：张俊
 * @date ：Created in 2022/11/21 9:55
 * @description： spring jpa的 分页执行器
 */
public class GwSpringJpaPageHelper/* implements GiPageExcuter */{

	/**
	 * 从GwSort对象拼装 Spring Data Jpa Sort
	 * @param sort
	 * @return
	 */
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public static Sort sortFromGwSort(GwSort sort) {
		
		Sort jpaSort = Sort.unsorted();
		if(sort != null) {
        	Iterator<GwOrder<?>> iterator = sort.iterator();
        	while(iterator.hasNext()) {
        		
        		GwOrder<?> order = iterator.next();
        		if(order.getPropertyFun() != null) {
        			Class<?> cls = order.getEntityClass();
        			
        			Sort sort1 = Sort.sort(cls).by((Function)order.getPropertyFun());
        			
        			if(order.getDirection() == GwOrder.Direction.DESC) {
        				jpaSort = jpaSort.and(sort1.descending());
        			}else {
        				jpaSort = jpaSort.and(sort1);
        			}
        		}else if(order.getProperty() != null) {
        			jpaSort = jpaSort.and(Sort.by(Direction.fromString(order.getDirection().value()), order.getProperty()));
        		}
        	}
        }
		
		return jpaSort;
	}
    
	/**
	 * 从GwPageParam 转换 Spring Data Jpa Pageable (spring data jpa 的页码从0开始)
	 * @param pageParam
	 * @return
	 */
    public static Pageable toPageable(GiPageParam pageParam) {
		int pageNum = pageParam.pageNum()-1;
        int pageSize = pageParam.pageSize();
        PageRequest pageRequest = PageRequest.of(pageNum, pageSize,sortFromGwSort(pageParam.sort()));
        return pageRequest;
	}
    
    
/*
    @Override
    public <R> GiPager<R> excutePage(GfunPageExcute<R> pageExcute, GiPageParam pageParam) {

//        int pageNum = pageParam.pageNum();
//        int pageSize = pageParam.pageSize();
//
//        PageRequest of = PageRequest.of(pageNum, pageSize);
//
//        Iterable<R> excute = pageExcute.excute();
//
//        Page pageobj = simpleJpaRepository.findAll(of);
//        pageParam.putParam(pageobj.getSize(), pageobj.getNumber(), null);
//        GwPager<R> pager = pageExcute.getGwPager();
//        pager.put(pageobj.toList(), pageobj.getTotalElements(), pageParam);
        return null;
    }
*/

}
