/*
 * Decompiled with CFR 0.152.
 */
package com.gw.orm.springjpa.extra;

import com.gw.base.Gw;
import com.gw.base.exception.GwException;
import com.gw.base.gpa.entity.GiEntityable;
import com.gw.base.util.GutilReflection;
import com.gw.orm.springjpa.util.EntityManagerProvider;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Iterator;
import javax.persistence.EntityManager;
import org.springframework.transaction.annotation.Transactional;

public interface BatchRepository<T extends GiEntityable<PK>, PK extends Serializable> {
    public static final Integer BATCH_SIZE = 500;

    @Transactional
    default public <S extends T> Iterable<S> batchSave(Iterable<S> collect) {
        EntityManager entityManager = EntityManagerProvider.getEntityManagerProvider().getEntityManager();
        Iterator<S> iterator = collect.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            GiEntityable next = (GiEntityable)iterator.next();
            if (entityManager.contains((Object)next)) {
                Gw.log.warn("\u8be5\u5bf9\u8c61\u6570\u636e\u5e93\u4e2d\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c!\uff1a{}->{}", new Object[]{next.getClass().getName(), Gw.toJson((Object)next).toJSONString()});
            } else {
                entityManager.persist((Object)next);
            }
            if (++index % BATCH_SIZE != 0) continue;
            entityManager.flush();
            entityManager.clear();
        }
        if (index % BATCH_SIZE != 0) {
            entityManager.flush();
            entityManager.clear();
        }
        return collect;
    }

    @Transactional
    default public <S extends T> Iterable<S> batchUpdate(Iterable<S> collect) {
        EntityManager entityManager = EntityManagerProvider.getEntityManagerProvider().getEntityManager();
        Iterator<S> iterator = collect.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            GiEntityable next = (GiEntityable)iterator.next();
            boolean contains = entityManager.contains((Object)next);
            if (contains) {
                entityManager.merge((Object)next);
            } else {
                Gw.log.warn("\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8be5\u5bf9\u8c61\uff0c\u4e0d\u6267\u884c\u66f4\u65b0\u64cd\u4f5c\uff01\uff1a{}->{}", new Object[]{next.getClass().getName(), Gw.toJson((Object)next).toJSONString()});
            }
            if (++index % BATCH_SIZE != 0) continue;
            entityManager.flush();
            entityManager.clear();
        }
        if (index % BATCH_SIZE != 0) {
            entityManager.flush();
            entityManager.clear();
        }
        return collect;
    }

    @Transactional
    default public <S extends T> Iterable<S> batchUpdateSelective(Iterable<S> collect) {
        EntityManager entityManager = EntityManagerProvider.getEntityManagerProvider().getEntityManager();
        Iterator<S> iterator = collect.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            GiEntityable next = (GiEntityable)iterator.next();
            GiEntityable dabaseObj = (GiEntityable)entityManager.find(next.getClass(), (Object)next.id());
            if (dabaseObj != null) {
                Field[] fields;
                for (Field field : fields = dabaseObj.getClass().getDeclaredFields()) {
                    try {
                        GutilReflection.makeAccessible((Field)field);
                        if (field.get(dabaseObj) == null || field.get(next) != null) continue;
                        field.set(next, field.get(dabaseObj));
                    }
                    catch (Exception e) {
                        throw new GwException("po\u5bf9\u8c61\u65e0\u6cd5\u53cd\u5c04\u8d4b\u503c\uff0c\u8bf7\u68c0\u67e5\u5bf9\u8c61\u914d\u7f6e", (Throwable)e);
                    }
                }
                entityManager.merge((Object)next);
            } else {
                Gw.log.warn("\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8be5\u5bf9\u8c61\uff0c\u4e0d\u6267\u884c\u66f4\u65b0\u64cd\u4f5c\uff01\uff1a{}->{}", new Object[]{next.getClass().getName(), Gw.toJson((Object)next).toJSONString()});
            }
            if (++index % BATCH_SIZE != 0) continue;
            entityManager.flush();
            entityManager.clear();
        }
        if (index % BATCH_SIZE != 0) {
            entityManager.flush();
            entityManager.clear();
        }
        return collect;
    }
}

