/*
 * Decompiled with CFR 0.152.
 */
package com.gw.orm.springjpa.impls;

import com.gw.base.Gw;
import com.gw.base.exception.GwException;
import com.gw.base.gpa.dao.GiUpdateDao;
import com.gw.base.gpa.entity.GiEntityAlterable;
import com.gw.base.util.GutilObject;
import com.gw.base.util.GutilReflection;
import com.gw.orm.springjpa.extra.BatchRepository;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;

public interface UpdateRepository<T extends GiEntityAlterable<PK>, PK extends Serializable>
extends JpaRepository<T, PK>,
GiUpdateDao<T, PK> {
    default public void gwUpdateByPK(T t) {
        if (GutilObject.isNull((Object)t.id())) {
            throw new GwException("\u66f4\u65b0\u7684\u5bf9\u8c61ID\u4e0d\u5b58\u5728");
        }
        boolean b = this.existsById(t.id());
        if (!b) {
            throw new GwException("\u975e\u66f4\u65b0\u64cd\u4f5c! \u5bf9\u8c61: {}", new Object[]{Gw.toJson(t).toJSONString()});
        }
        this.save(t);
    }

    default public void gwUpdateByPKSelective(T t) {
        Field[] fields;
        Serializable pk = t.id();
        if (GutilObject.isNull((Object)pk)) {
            throw new GwException("\u66f4\u65b0\u7684\u5bf9\u8c61ID\u4e0d\u5b58\u5728");
        }
        GiEntityAlterable orig = this.findById(pk).orElse(null);
        if (GutilObject.isNull((Object)orig)) {
            throw new GwException("\u975e\u66f4\u65b0\u64cd\u4f5c! \u5bf9\u8c61: {}", new Object[]{Gw.toJson(t).toJSONString()});
        }
        for (Field field : fields = t.getClass().getDeclaredFields()) {
            try {
                GutilReflection.makeAccessible((Field)field);
                if (field.get(orig) == null || field.get(t) != null) continue;
                field.set(t, field.get(orig));
            }
            catch (Exception e) {
                throw new GwException("po\u5bf9\u8c61\u65e0\u6cd5\u53cd\u5c04\u8d4b\u503c\uff0c\u8bf7\u68c0\u67e5\u5bf9\u8c61\u914d\u7f6e", (Throwable)e);
            }
        }
        this.saveAndFlush(t);
    }

    default public void gwUpdateByPK(List<T> records) {
        if (!(this instanceof BatchRepository)) {
            throw new GwException("{} \u6ca1\u6709\u5b9e\u73b0\u4efb\u4f55\u6279\u91cf\u66f4\u65b0\u63a5\u53e3;\u8bf7\u5728JPA\u7684\u8be5\u5bf9\u8c61\u7684 Repository\u5c42 \u7ee7\u627f  com.gw.orm.springjpa.extra.BatchRepository;", new Object[]{this.getClass().getName()});
        }
        BatchRepository dao = (BatchRepository)((Object)this);
        dao.batchUpdate(records);
    }

    default public void gwUpdateByPKSelective(List<T> records) {
        if (!(this instanceof BatchRepository)) {
            throw new GwException("{} \u6ca1\u6709\u5b9e\u73b0\u4efb\u4f55\u6279\u91cf\u66f4\u65b0\u63a5\u53e3;\u8bf7\u5728JPA\u7684\u8be5\u5bf9\u8c61\u7684 Repository\u5c42 \u7ee7\u627f  com.gw.orm.springjpa.extra.BatchRepository;", new Object[]{this.getClass().getName()});
        }
        BatchRepository dao = (BatchRepository)((Object)this);
        dao.batchUpdateSelective(records);
    }
}

